﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Result.h>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/util/util_FormatString.h>
#include <nn/mbuf/mbuf_Mbuf.h>
#include <nn/mbuf/mbuf_MbufInit.h>

#include <dhd_horizon.h>
#include <bwl.h>
#include "../wlan_MemoryInit.h"
#include "wlan_Type.h"
#include "wlan_Test.h"
#include "wlan_TestTxRx.h"
#include "wlan_TestBwlApi.h"
#include <cstring>

#ifdef USE_LOCALWL
#include "../dbg/wlan_Htcs.h"
#include "../dbg/wlan_DbgConsole.h"
#endif

extern void wlanGpioPowerEnable(bool);
extern void wlanPrintOutBtGpioDirections();
extern void wlanConfigureBtGpio(int btGpioNumber, bool isOutput, bool power);

// define USE_WL_CMDTOOL here if desired
#ifdef USE_WL_CMDTOOL
extern "C" void RwlManager(void);
extern "C" void wlu_init(void);
#endif /* USE_WL_CMDTOOL */


namespace {


}   // namespace




namespace nn {
namespace wlan {


void WlanInitialize() NN_NOEXCEPT
{
    nn::wlan::InitializeMbuf();
}

void WlanFinalize() NN_NOEXCEPT
{
    nn::wlan::FinalizeMbuf();
    nn::wlan::FinalizeMemory();
}

void TestBwlUp()
{

}

void TestBwlDown()
{

}


void TestBwlSetApmode()
{

}

void TestBwlSetInframode()
{

}

void TestMain()
{
    NN_LOG("[WLAN]looping\n");
    //NN_LOG("BWL1 : %d\n", BWL_sampleApi(10));
    //NN_LOG("BWL2 : %d\n", BWL_sample2Api(50,100));
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(1000));
    NN_LOG("[WLAN]loop EXIT\n");
}

void WlanUpCommand()
{

}

}
}

extern "C" void nninitStartup()
{
    nn::wlan::InitializeMemory();
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::Result      result;

    NN_LOG("\n\n\nwlan process starts: Date %s Time %s\n", __DATE__, __TIME__);


#if 1
    // proper shutdown doesn't happen yet, so before starting force reset and short delay
    //wlanGpioPowerEnable(false);
    //nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));

    wlanGpioPowerEnable(true);
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(100));
#endif

    nn::wlan::WlanInitialize();
#ifdef USE_LOCALWL
    // wlandbg
    nn::wlan::dbg::wlan_DbgConsoleInit();
#endif


#define DO_WLAN_TEST
#ifdef DO_WLAN_TEST
    nn::wlan::Test test;

    nn::wlan::TestTxRx testTxRx;
    testTxRx.Initialize();

#ifdef USE_WL_CMDTOOL
    // Disabled by default
    NN_LOG("\n\n\nWLAN PROCESS UP: STARTING RWL: Master config \n");
    wlu_init();
    RwlManager();
#endif /* USE_WL_CMDTOOL */

#if 0
    test.Initialize();

    test.ScanTest();
    test.Deinitialize();
#endif
#if 0 // Test load and Unload
    testTxRx.ApTestMode();
    nn::os::SleepThread(nn::TimeSpan::FromSeconds(20));
#endif

#if 1 //Configured as Master
    testTxRx.ApTest();
#endif

#if 0 //Configured as Client
    testTxRx.StaTest();
#endif

    testTxRx.Deinitialize();

#if 0
    // Test API out-of-bound values robustness.
    {
        nn::wlan::TestBwlApi testBwlApi;
        testBwlApi.Run();
    }
#endif

#endif /* DO_WLAN_TEST */

    nn::wlan::WlanFinalize();



    NN_LOG("wlan process ends\n\n\n");
}
