﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/psc.h>

/*
    @file Prod 環境で動作する tma プロセスのスタブ
    @detail
        fs プロセスなどが PmModuleId_TmHostIo に依存しているため、
        PmModuleId_TmHostIo を登録し、ダミーのスリープハンドラ処理を行うことが必要になっている。
        (cf. SIGLO-35912)
*/

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::Result result;
    nn::psc::PmModule module;

    // psc モジュール登録
    result = module.Initialize(nn::psc::PmModuleId_TmHostIo, nullptr, 0, nn::os::EventClearMode_ManualClear);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    // 空のスリープハンドラ
    nn::psc::PmState state;
    nn::psc::PmFlagSet flags;

    while(true)
    {
        module.GetEventPointer()->Wait();

        module.GetEventPointer()->Clear();

        result = module.GetRequest( &state, &flags );
        NN_ABORT_UNLESS_RESULT_SUCCESS( result );

        result = module.Acknowledge( state, nn::ResultSuccess() );
        NN_ABORT_UNLESS_RESULT_SUCCESS( result );
    }

    // Unreachable code
    //module.Finalize();
}
