﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/socket/socket_Api.h>
#include <nn/htcs.h>
#include <nn/htcs/htcs_LibraryPrivate.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/sm/sm_UserApi.h>

#include <nn/ldr/ldr_ShellApi.h>
#include <nn/lr/lr_Service.h>

#include <nn/nn_TimeSpan.h>
#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/ns/ns_DevelopApi.h>
#include "shell_HtcsLibraryAllocator.h"
#include "shell_TelnetServer.h"
#include "shell_ProcessManagement.h"

#include <nn/nn_SdkLog.h>

namespace {
    const int SocketCountMax = 4;
}

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain() NN_NOEXCEPT
{
    nn::sm::Initialize();

    nn::shell::detail::InitializeHtcsLibraryAllocator();

    size_t bufferSize = nn::htcs::GetWorkingMemorySize(SocketCountMax);
    void* buffer = nn::shell::detail::HtcsLibraryHeapAllocate(bufferSize);
    NN_SDK_ASSERT_NOT_NULL(buffer);

    nn::htcs::InitializeForSystem(buffer, bufferSize, 4);

    nn::Result result;

    result = nn::ns::InitializeForDevelop();
    NN_ABORT_UNLESS(result.IsSuccess(), "result=%08x", result);

    result = nn::ldr::InitializeForShell();
    NN_ABORT_UNLESS(result.IsSuccess(), "result=%08x", result);

    nn::lr::Initialize();

    nn::shell::InitializeProcessManager();
    nn::shell::InitializeTelnetServer();

    for (;;)
    {
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000) );
    }

}

