﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

namespace nn { namespace shell {

class Console
{
protected:
    Console() NN_NOEXCEPT {}
    ~Console() NN_NOEXCEPT {}

public:
    // 読み取れたら true
    bool ReadLine(char *buffer, int bufferLength) NN_NOEXCEPT;
    int TPrintf(const char *format, ...) NN_NOEXCEPT;
    void PutString(const char *pString) NN_NOEXCEPT;
    void Flush() NN_NOEXCEPT
    {
        FlushCore();
    }
public:
    static const int EndOfStream = -1;
protected:
    virtual void PutChar(int c) NN_NOEXCEPT = 0;
    virtual void FlushCore() NN_NOEXCEPT = 0;
    virtual int GetChar() NN_NOEXCEPT = 0;
};

class BufferedWriter
{
public:
    BufferedWriter(char* writeBuffer, int writeBufferLength) NN_NOEXCEPT;

    void PutChar(int c) NN_NOEXCEPT;
    void PutString(const char* pString) NN_NOEXCEPT;
    void Flush() NN_NOEXCEPT;
protected:
    virtual bool Write(char* pBuffer, int length) NN_NOEXCEPT = 0;
private:
    char*   m_WriteBuffer;
    int     m_WriteBufferLength;
    int     m_StoredLength;
};

}}    // namespace nn { namespace shell {
