﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SystemThreadDefinition.h>
#include <nn/os/os_Thread.h>
#include <nn/pl/srv/pl_HipcServer.h>

#include "sdb_PlatformServiceManagerMain.h"

namespace nn { namespace sdb {

namespace
{
    const size_t ServerStackSize = 1024 * 16;
    NN_OS_ALIGNAS_THREAD_STACK Bit8 g_ServerStack[ServerStackSize];
    nn::os::ThreadType g_ServerThread;

    void ServerThreadFunc(void*) NN_NOEXCEPT
    {
        nn::pl::srv::LoopAuto();
    }

} // ~namespace nn::sdb::<anonymous>

void RegisterPlatformServiceManager() NN_NOEXCEPT
{
    nn::pl::srv::CreateServer();
}

void StartPlatformServiceManagerMain() NN_NOEXCEPT
{
    nn::pl::srv::StartServer();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(&g_ServerThread, ServerThreadFunc, nullptr, g_ServerStack, ServerStackSize, NN_SYSTEM_THREAD_PRIORITY(pl, IpcServer)));
    nn::os::SetThreadNamePointer(&g_ServerThread, NN_SYSTEM_THREAD_NAME(pl, IpcServer));
    nn::os::StartThread(&g_ServerThread);
}

}} // ~namespace nn::sdb
