﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_BitPack.h>
#include <nn/os/os_Types.h>

#include "profiler_Memory.h"

//#define USE_ATOMIC_POINTER

#if defined(USE_ATOMIC_POINTER)
#include <atomic>
#define FETCH_ADD(ptr, amt) ((ptr).fetch_add(amt))
#else
#define FETCH_ADD(ptr, amt) (ptr); ((ptr) += (amt))
#endif

namespace nn { namespace profiler {

struct SettingsFromThePcGui;

struct WorkArea
{
    // set this before entering the profile loop
    uint8_t* startPtr;
#if defined(USE_ATOMIC_POINTER)
    std::atomic<uint8_t*> curPtr;
#else
    uint8_t* curPtr;
#endif
    uint8_t* sentinel;
    SettingsFromThePcGui* settings;

    nn::os::ThreadId thread_to_profile;
    uint32_t time_between_samples;

    uint8_t record_cores;           // used as a bitfield
    uint8_t core_number;            // used as an integer

    uintptr_t tempStack;

    // booleans
    nn::util::BitPack16 fields;
    enum
    {
        IsUsingPerfCounters,
        SampleUsingPerfCounters,
        UseInfiniteTime,
        RecordPerformanceCounters,
        RecordPerformanceCounterCycles,
        RecordCodeblocksOnly,
        ThreadInSystemCall,
        Is64Bit,
    };

    struct Context
    {
        uint64_t fp;
        uint64_t sp;
        uint64_t lr;
        uint64_t pc;
    } context;
};


void InitializeWorkAreas();
void FinalizeWorkAreas();


WorkArea* GetWorkAreaForCore(SampleBufferIndex index);
void InitializeCoreWorkArea(SampleBufferIndex index);
void FinalizeCoreWorkArea(SampleBufferIndex index);
bool GetMoreSampleBuffer(SampleBufferIndex index);
bool ObtainAndSetupSampleBuffer(SampleBufferIndex index);
bool CheckAndExpandBuffersIfNeeded(SampleBufferIndex index);


} // profiler
} // nn
