﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace profiler {

enum NotificationType : uint32_t
{
    NotificationType_Error      = 0 << 24,
    NotificationType_Warning    = 1 << 24,
    NotificationType_Info       = 2 << 24,
    NotificationType_Question   = 3 << 24
};

const int NotificationErrorBufferSize               = (NotificationType_Error | 1);
const int NotificationErrorUnableToStartApp         = (NotificationType_Error | 2);
const int NotificationErrorVersionMismatch          = (NotificationType_Error | 3);
const int NotificationErrorInvalidAddrRange         = (NotificationType_Error | 4);
const int NotificationErrorUnsupportedCore          = (NotificationType_Error | 5);
const int NotificationErrorNoProfilingClient        = (NotificationType_Error | 6);
const int NotificationErrorDidNotProfile            = (NotificationType_Error | 7);
const int NotificationErrorCouldNotAttach           = (NotificationType_Error | 8);

const int NotificationWarningInvalidInstructionAddr = (NotificationType_Warning | 1);
const int NotificationWarningThreadIdTooHigh        = (NotificationType_Warning | 2);
const int NotificationWarningTooManyThreads         = (NotificationType_Warning | 3);
const int NotificationWarningPmuNotAvailable        = (NotificationType_Warning | 4);
const int NotificationWarningInvalidQuery           = (NotificationType_Warning | 5);
const int NotificationWarningDebuggerAttached       = (NotificationType_Warning | 6);

} // profiler
} // nn
