﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

NN_PRAGMA_PUSH_WARNINGS
#pragma GCC diagnostic ignored "-Wsign-conversion"
#include <nn/os.h>
NN_PRAGMA_POP_WARNINGS

#include "profiler_Logging.h"
#include "profiler_ResultPrivate.h"

#define FORCE_SEND(x) do { \
        DUMP_CURRENT_LINE(); \
        nn::Result forceSendResult = (x); \
        while (::nn::profiler::ResultPccomQueueFull::Includes(forceSendResult)) \
        { \
            nn::os::SleepThread(nn::TimeSpan::FromMicroSeconds(50)); \
            forceSendResult = (x); \
        } \
        if (forceSendResult.IsFailure()) \
        { \
            DumpResultInformation(LOG_AS_ERROR, forceSendResult); \
        } \
    } while (NN_STATIC_CONDITION(false))

