﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>


namespace nn { namespace profiler {

enum HeaderSpecialValues : uint32_t
{
    HeaderSpecialValues_MasterHeaderBegin = ('N' << 24) | ('X' << 16) | ('M' << 8) | 'H',
    HeaderSpecialValues_CoreHeaderBegin =   ('N' << 24) | ('X' << 16) | ('C' << 8) | 'H',
    HeaderSpecialValues_ThreadHeaderBegin = ('N' << 24) | ('X' << 16) | ('T' << 8) | 'H',

    HeaderSpecialValues_HeaderVersion = 0x100, // -> u32
    HeaderSpecialValues_RuntimeVersion = 0x101, // -> u32
    HeaderSpecialValues_RuntimeSdkVersion = 0x102, // -> u32
    HeaderSpecialValues_ApplicationSdkVersion = 0x103, // -> u32
    HeaderSpecialValues_ApplicationPointerSize = 0x104, // -> u32

    HeaderSpecialValues_Flags = 0x200, // -> u32(mask)
    HeaderSpecialValues_CoresRecorded = 0x201, // -> u32(mask)
    HeaderSpecialValues_CoreNumber = 0x202, // -> u32
    HeaderSpecialValues_CoreOffset = 0x203, // -> u32, u32
    HeaderSpecialValues_ThreadListOffset = 0x204, // -> u32
    HeaderSpecialValues_NsoRegionOffset = 0x205, // -> u32
    HeaderSpecialValues_UserMarkerNames = 0x206, // -> u32(offset), s32(version), s32(count)
    HeaderSpecialvalues_UserMarkerNamesBase = 0x207, // -> u64(baseAddress)
    HeaderSpecialValues_NvnFuncNamesOffset = 0x208, // -> u32(offset)
    HeaderSpecialValues_InstrumentedOffset = 0x209, // -> u32(offset), u32(version), u32(size), u32(hasPerf)

    // Followed by A and B perf
    HeaderSpecialValues_PerformanceCounterSlots = 0x300, // -> u16[SUPPORTED_CORE_COUNT], u32

    HeaderSpecialValues_BaseTime = 0x400, // -> u64
    HeaderSpecialValues_RequestedTimeBetweenSamples = 0x401, // -> u32
    HeaderSpecialValues_TimeUnitsPerSecond = 0x402, // -> u64

    HeaderSpecialValues_Dlls = 0x500, // -> u32

    HeaderSpecialValues_HeaderEnd = 0xFFFFFFFE,
};



enum PayloadEvents : uint32_t
{
    PayloadEvents_Sample = 0,
    PayloadEvents_ThreadInSystemCall = (1 << 0),

    PayloadEvents_Base = 0xFFFFFF00,

    PayloadEvents_Time = (PayloadEvents_Base | 0x10),

    PayloadEvents_NoActiveThread = (PayloadEvents_Base | 0x30),
    PayloadEvents_UnknownActiveThread = (PayloadEvents_Base | 0x31),
    PayloadEvents_ProfilerActiveThread = (PayloadEvents_Base | 0x32),

    PayloadEvents_HeartbeatBase = (PayloadEvents_Base | 0x40),
    // Heartbeats use 0x40 through 0x4F as the heartbeat number is OR'd into the low nybble

    PayloadEvents_PowerStatistics = (PayloadEvents_Base | 0x50),

    PayloadEvents_UserBase = (PayloadEvents_Base | 0xA0),
    PayloadEvents_UserTopMainLoop = (PayloadEvents_UserBase | 0x0),
    PayloadEvents_UserVBlank = (PayloadEvents_UserBase | 0x1),
    PayloadEvents_UserTimeInFunc = (PayloadEvents_UserBase | 0x2),
    PayloadEvents_UserPlotInt = (PayloadEvents_UserBase | 0x3),
    PayloadEvents_UserPlotFloat = (PayloadEvents_UserBase | 0x4),
    PayloadEvents_UserPlotVec2 = (PayloadEvents_UserBase | 0x5),
    PayloadEvents_UserAllocate = (PayloadEvents_UserBase | 0x6),
    PayloadEvents_UserDeallocate = (PayloadEvents_UserBase | 0x7),
    // User events use 0xA0 through 0xAF

    PayloadEvents_InstrumentEnter = (PayloadEvents_Base | 0xB0),
    PayloadEvents_InstrumentExit = (PayloadEvents_Base | 0xB1),
    PayloadEvents_CodeBlockEnter = (PayloadEvents_Base | 0xB2),
    PayloadEvents_CodeBlockExit = (PayloadEvents_Base | 0xB3),
    // "Instrumented" events use 0xB0 throgh 0xBF
};


enum PayloadGenericEvents : uint32_t
{
    PayloadGenericEvents_End = 0x1,
};

} // profiler
} // nn
