﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_EventTypes.h>

#include "profiler_SettingsFromThePcGui.h"

namespace nn { namespace profiler {

// startup the comms layer
void InitializeCommunicationsLayer();
void FinalizeCommunicationsLayer();

// once signaled, 'settings_to_use' is valid, and we should start profiling.
nn::os::EventType* CheckForBegin(SettingsFromThePcGui* settings_to_use);

// the comms layer should signal the event when the xfer is done
nn::os::EventType* SendDataToPC();
nn::os::EventType* GetTransferCompleteEvent();

void SignalBeginEvent();
nn::os::EventType* GetStopEvent();

// sends a notification to the server with a message detailing the problem
//  (may change to a number later)
void SendNotificationToPC(
    uint32_t code,
    nn::Result result);

// sends a notification to the server stating that the profiler is ready to
//  begin profiling
void SendReadyToProfile(size_t maxBuffSize);

// sends a notification to the server stating that profiling has begun
void SendProfilingHasBegun();

// Tells the GUI that a specific core is available for selection.
void SendCoreAvailable(uint32_t coreMask);

bool IsPCConnected();

} // profiler
} // nn
