﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_EventTypes.h>

#include "pmu/profiler_PerfCounterGroups.h"

namespace nn { namespace profiler { namespace pmu {

struct PerformanceCounters
{
    uint64_t cycles;
    uint32_t counters[PerformanceCounterCount];
};

bool IsAvailable();
void Initialize();
void Finalize();

void SetCounters(uint16_t counters[PerformanceCounterCount]);
bool ReadCounters(PerformanceCounters& data, uint32_t core, bool samplerThread);
void StopCounters();

nn::os::EventType* GetInterrupt(uint32_t core);
void SetInterrupt(PerfCounter type, uint32_t waitTime, uint32_t core);
void ResetInterrupt(uint32_t core);

void SoftwareIncrement();

} // pmu
} // profiler
} // nn
