﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/settings/settings_Result.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

#include "detail/settings_SettingsGetterApiImpl.h"

#include <nn/nn_SdkLog.h>

namespace nn { namespace settings { namespace fwdbg {

bool IsDebugModeEnabled() NN_NOEXCEPT
{
    return false;
}

size_t GetSettingsItemValue(void* buffer,
                            size_t bufferSize,
                            const char* name,
                            const char* key) NN_NOEXCEPT
{
    //
    // セーフモードの pcv で利用
    // セーフモードでは、FS の準備が整う前に pcv を利用するため、
    // その際に settings に問い合わせを行わないよう shim で固定値を返す
    //
    if (std::strncmp("bpc", name, 4)==0 && std::strncmp("enable_quasi_off", key, 17)==0)
    {
        std::memset(buffer, 1, 1);
        return 1;
    }
    if (std::strncmp("nv", name, 3)==0)
    {
        std::memset(buffer, 0, 1);
        return 1;
    }
    NN_SDK_LOG("[settings] name=%s key=%s\n", name, key);

    size_t value = 0;
    NN_ABORT_UNLESS_RESULT_SUCCESS(
        ::nn::settings::detail::GetSettingsItemValue(
            &value, buffer, bufferSize, name, key));
    return value;
}

}}} // namespace nn::settings::hwdbg
