﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "ns_AddOnContentManagerMain.h"
#include <nn/aocsrv/aocsrv_AddOnContentHipcServer.h>

#include "ns_DelayedInitializer.h"
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/os/os_Thread.h>

namespace nn { namespace ns {
namespace {
const size_t ServerStackSize = 1024 * 16;
NN_OS_ALIGNAS_THREAD_STACK nn::Bit8 g_ServerStack[ServerStackSize];
nn::os::ThreadType g_ServerThread;

void IpcDispatcher(void*) NN_NOEXCEPT
{
    WaitDelayedInitialization();

    nn::aocsrv::LoopAuto();
}
} // ~namespace nn::ns::<anonymous>

void RegisterAddOnContentManager() NN_NOEXCEPT
{
    nn::aocsrv::CreateServer();
}

void StartAddOnContentManagerMain() NN_NOEXCEPT
{
    nn::aocsrv::StartServer();

    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateThread(
        &g_ServerThread,
        IpcDispatcher,
        nullptr,
        g_ServerStack,
        ServerStackSize,
        NN_SYSTEM_THREAD_PRIORITY(aocsrv, IpcDispatcher)));

    nn::os::SetThreadNamePointer(&g_ServerThread, NN_SYSTEM_THREAD_NAME(aocsrv, IpcDispatcher));
    nn::os::StartThread(&g_ServerThread);
}

void StopAddOnContentManagerMain() NN_NOEXCEPT
{
    nn::aocsrv::RequestStopServer();

    nn::os::WaitThread(&g_ServerThread);
    nn::os::DestroyThread(&g_ServerThread);

    nn::aocsrv::DestroyServer();
}

}}
