﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/socket.h>
#include <nn/init.h>
#include <nn/os.h>
#include <nn/npns/detail/npns_Utility.h>
#include <mutex>
#include <cstdlib>

extern "C" {
#include <src/common.h>
}

#include "npns_Xmpp.h"

namespace nn{ namespace npns{

Xmpp::Text::Text()
    : m_pContext(nullptr), m_pText(nullptr)
{
}

Xmpp::Text::~Text()
{
    Free();
}

void Xmpp::Text::Set(xmpp_ctx_t* pContext, char* pText)
{
    Free();
    m_pContext = pContext;
    m_pText = pText;
}

const char* Xmpp::Text::Get() const
{
    return m_pText;
}

size_t Xmpp::Text::GetLength() const
{
    if (!m_pText)
    {
        return 0;
    }
    return std::strlen(m_pText);
}

void Xmpp::Text::Free()
{
    if (m_pText)
    {
        xmpp_free(m_pContext, m_pText);
        m_pText = NULL;
    }
}

}}
