﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <mutex>

#include "npns_SuspendManager.h"
#include "npns_Instance.h"
#include "npns_StateMachineThread.h"

namespace nn{ namespace npns{

os::Mutex SuspendManager::s_Mutex(true);

SuspendManager::SuspendManager()
    : m_Count(0)
{
}
SuspendManager::~SuspendManager()
{
}

void SuspendManager::Suspend()
{
    std::lock_guard<os::Mutex> lock(s_Mutex);

    NN_SDK_ASSERT(m_Count >= 0);

    if (m_Count++ == 0)
    {
        StateMachineThread& smt = g_Daemon.GetStateMachineThread();
        smt.SetAutonomyEnabled(false);
        Result result = smt.RequestChangeState(State_Suspend);
        if (result.IsFailure())
        {

        }
    }
}

void SuspendManager::Resume()
{
    std::lock_guard<os::Mutex> lock(s_Mutex);

    NN_SDK_ASSERT(m_Count > 0);

    if (--m_Count == 0)
    {
        StateMachineThread& smt = g_Daemon.GetStateMachineThread();
        smt.SetAutonomyEnabled(true);

        smt.RequestChangeStateAsync(State_Connected);
    }
}

SuspendManager::SuspendClient::SuspendClient(SuspendManager & manager)
    : m_SuspendManager(manager)
    , m_Count(0)
{
}

SuspendManager::SuspendClient::~SuspendClient()
{
    if (m_Count > 0)
    {
        m_SuspendManager.Resume();
    }
}

void SuspendManager::SuspendClient::Suspend()
{
    if (m_Count++ == 0)
    {
        m_SuspendManager.Suspend();
    }
}

void SuspendManager::SuspendClient::Resume()
{
    if (--m_Count == 0)
    {
        m_SuspendManager.Resume();
    }
}

SuspendManager::ScopedSuspender::ScopedSuspender(SuspendClient & client)
    : m_client(client)
{
    m_client.Suspend();
}

SuspendManager::ScopedSuspender::~ScopedSuspender()
{
    m_client.Resume();
}

}
}
