﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_ContextControl.h>

#include "npns_Router.h"
#include "npns_NotificationQueue.h"
#include "npns_SuspendManager.h"

namespace nn { namespace npns {

class SuspendManager;
class ServiceImpl
{
public:
    ServiceImpl();
    ~ServiceImpl();

    nn::Result ListenAll() NN_NOEXCEPT;
    nn::Result ListenTo(nn::ApplicationId toId) NN_NOEXCEPT;
    nn::Result ListenToMyApplicationId(nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result ListenUndelivered() NN_NOEXCEPT;
    nn::Result Receive(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result ReceiveRaw(const nn::sf::OutBuffer& outBuffer, std::uint16_t version) NN_NOEXCEPT;
    nn::Result GetReceiveEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result GetStateChangeEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result SubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result UnsubscribeTopic(const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result QueryIsTopicExist(nn::sf::Out<bool> bResult, const nn::sf::InArray<char>& name) NN_NOEXCEPT;
    nn::Result CreateToken(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result CreateTokenWithApplicationId(nn::sf::Out<nn::npns::NotificationToken> outToken, const nn::account::Uid& uid, ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result DestroyToken(const account::Uid& uid, nn::Bit64 processId) NN_NOEXCEPT;
    nn::Result DestroyTokenWithApplicationId(const account::Uid& uid, ApplicationId applicationId) NN_NOEXCEPT;
    nn::Result QueryIsTokenValid(nn::sf::Out<bool> bResult, const nn::npns::NotificationToken& token) NN_NOEXCEPT;
    nn::Result UploadTokenToBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result DestroyTokenForBaaS(const nn::account::Uid& uid) NN_NOEXCEPT;
    nn::Result Suspend() NN_NOEXCEPT;
    nn::Result Resume() NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::int32_t> outState) NN_NOEXCEPT;
    nn::Result GetStatistics(const nn::sf::OutBuffer& outStatistics) NN_NOEXCEPT;
    nn::Result GetPlayReportRequestEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT;
    nn::Result CreateJid() NN_NOEXCEPT;
    nn::Result DestroyJid() NN_NOEXCEPT;
    nn::Result AttachJid(const nn::sf::InArray<char>& jid, const nn::sf::InArray<char>& password) NN_NOEXCEPT;
    nn::Result DetachJid(const nn::sf::OutArray<char>& jid, const nn::sf::OutArray<char>& password) NN_NOEXCEPT;
    nn::Result GetJid(const nn::sf::OutArray<char>& jid) NN_NOEXCEPT;

    static bool IsWorkerContext();
    enum RequiredStateFlag
    {
        RequiredStateFlag_Online              = 1 << 0,
        RequiredStateFlag_Connected           = 1 << 1,
        RequiredStateFlag_ValidJid            = 1 << 3,
    };
    static Result EnsureRequiredState(Bit32 requiredStateFlags);

    // for test only.
    nn::Result RequestChangeStateForceTimed(int32_t targetState, nn::TimeSpan timeout);
    nn::Result RequestChangeStateForceAsync(int32_t targetState);

private:
    os::SystemEvent m_event;
    NotificationQueue m_queue;
    Router::Entry m_routerEntry;
    SuspendManager::SuspendClient m_SuspendClient;
    bgsu::MultiClientSystemEvent::Node m_SystemEventNode;

    static SuspendManager s_SuspendManager;
};

}}
