﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

#include "npns_DeviceToken.h"

namespace nn{ namespace npns{

class DeviceTokenHolder
{
    NN_DISALLOW_COPY(DeviceTokenHolder);
    NN_DISALLOW_MOVE(DeviceTokenHolder);
public:
    DeviceTokenHolder();
    ~DeviceTokenHolder();

    DeviceToken& GetStorage();

    bool IsRefreshRequired() const;
    void RequestRefresh();
    void NotifySet();

private:

    DeviceToken m_Token;
    bool m_IsRefreshRequired;
};


}}


