﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <nn/dauth/dauth_Api.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
#include <nn/settings/system/settings_FirmwareVersion.h>
#endif

#include "npns_Common.h"
#include "npns_DeviceTokenConsumer.h"

namespace nn {
namespace npns {

DeviceTokenConsumer::DeviceTokenConsumer()
{
}

DeviceTokenConsumer::~DeviceTokenConsumer()
{
}

Result DeviceTokenConsumer::GetToken(DeviceToken *pOutToken, uint64_t clientId, bool ignoreCache)
{
    nn::TimeSpan expiration;
    int acquiredTokenSize;

    Result result = nn::dauth::AcquireDeviceAuthenticationToken(
            &expiration,
            &acquiredTokenSize,
            pOutToken->value,
            static_cast<int>(nn::npns::DeviceTokenLength),
            clientId,
            ignoreCache,
            nullptr // util::Cancelable
            );

    NN_NPNS_DETAIL_RETURN_IF_FAILED(result);

    NN_NPNS_TRACE("deviceToken = %s\n", pOutToken->value);
    return ResultSuccess();
}

}
}
