﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/npns.h>
#include <nn/os.h>
#include <nn/bgsu/bgsu_ThreadTemplate.h>
#include <mutex>

#include "npns_TypedMessageQueue.h"

namespace nn {
namespace npns {

    class IpcServerManager;
    class DeferredWorkerThread : public bgsu::ThreadTemplate<DeferredWorkerThread>
    {
        typedef bgsu::ThreadTemplate<DeferredWorkerThread> ThreadBase;
        static const int QueueDepth = 16;
    public:
        NN_IMPLICIT DeferredWorkerThread(IpcServerManager& server);
        ~DeferredWorkerThread();

        Result Initialize();
        void Finalize();

        Result DeferTask(os::MultiWaitHolderType* pHolder);
        bool IsWorkerThreadContext() const;

    protected:

        virtual void ThreadBody();
        virtual void RequestExit();
        void InvokeTask(os::MultiWaitHolderType* pHolder);

    private:
        IpcServerManager& m_IpcServermanager;
        os::ThreadLocalStorage m_tls;
        TypedMessageQueue<os::MultiWaitHolderType*, QueueDepth> m_TaskQueue;
    };

}
}
