﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet_FundamentalTypes.h>

#include <nn/btm/btm_IBtm.sfdl.h>

namespace nn { namespace btm {

class BtmImpl
{
private:
public:
    void GetStateImpl(nn::sf::Out<nn::btm::BtmState> pState) NN_NOEXCEPT;
    void GetHostDevicePropertyImpl(nn::sf::Out<nn::btm::HostDeviceProperty> pHostDeviceProperty) NN_NOEXCEPT;
    bool AcquireDeviceConditionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetDeviceConditionImpl(nn::sf::Out<nn::btm::DeviceConditionList> pList) NN_NOEXCEPT;
    nn::Result SetBurstModeImpl(nn::btm::BdAddress bdAddress, bool isBurstMode) NN_NOEXCEPT;
    nn::Result SetSlotModeImpl(const nn::btm::DeviceSlotModeList& deviceSlotModeList) NN_NOEXCEPT;
    nn::Result SetBluetoothModeImpl(nn::btm::BluetoothMode bluetoothMode) NN_NOEXCEPT;
    nn::Result SetWlanModeImpl(nn::btm::WlanMode wlanMode) NN_NOEXCEPT;
    void GetDeviceInfoImpl(nn::sf::Out<nn::btm::DeviceInfoList> pList) NN_NOEXCEPT;
    bool AcquireDeviceInfoEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void AddDeviceInfoImpl(const nn::btm::DeviceInfo& info) NN_NOEXCEPT;
    void RemoveDeviceInfoImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    void ProtectDeviceInfoImpl(nn::btm::BdAddress address, bool isProtect) NN_NOEXCEPT;
    void IncreaseDeviceInfoOrderImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    nn::Result LlrNotifyImpl(nn::btm::BdAddress address) NN_NOEXCEPT;
    void EnableRadioImpl() NN_NOEXCEPT;
    void DisableRadioImpl() NN_NOEXCEPT;
    bool AcquireAwakeReqEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void HidDisconnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result HidSetRetransmissionModeImpl(nn::btm::BdAddress bdAddress, const nn::btm::ZeroRetransmissionList& zeroRetransmissionList) NN_NOEXCEPT;
    bool AcquireLlrStateEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    bool IsLlrStartedImpl() NN_NOEXCEPT;
    void EnableSlotSavingImpl(bool isEnable) NN_NOEXCEPT;

    bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;

    nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<user::BleAdvFilterForGeneral> pFilter, uint16_t parameterId) NN_NOEXCEPT;
    nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<user::BleAdvFilterForSmartDevice> pFilter, uint16_t parameterId) NN_NOEXCEPT;

    nn::Result StartBleScanForGeneralImpl(user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
    void GetBleScanResultsForGeneralImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum) NN_NOEXCEPT;

    nn::Result StartBleScanForPairedDeviceImpl(user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;

    nn::Result StartBleScanForSmartDeviceImpl(user::BleAdvFilterForSmartDevice filter) NN_NOEXCEPT;
    nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
    void GetBleScanResultsForSmartDeviceImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum) NN_NOEXCEPT;

    bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BleConnectImpl(BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result BleOverrideConnectionImpl(uint32_t connectionHandle) NN_NOEXCEPT;
    nn::Result BleDisconnectImpl(uint32_t connectionHandle) NN_NOEXCEPT;
    void BleGetConnectionStateImpl(nn::sf::OutArray<user::BleClientConnState> pConnState, nn::sf::Out<uint8_t> pOutNum) NN_NOEXCEPT;
    void BleGetGattClientConditionListImpl(nn::sf::Out<GattClientConditionList> pGattClientConditionList) NN_NOEXCEPT;

    bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BlePairDeviceImpl(uint32_t connectionHandle, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceOnBothImpl(uint32_t connectionHandle, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    void BleGetPairedAddressesImpl(nn::sf::OutArray<BdAddress> pAddresses, nn::sf::Out<uint8_t> pOutNum, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;

    bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetGattServicesImpl(nn::sf::OutArray<user::GattService> pServices, nn::sf::Out<uint8_t> pOutNum, uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetGattServiceImpl(nn::sf::Out<user::GattService> pService, uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    bool GetBelongingServiceImpl(nn::sf::Out<user::GattService> pService, uint32_t connectionHandle, uint16_t attributeHandle) NN_NOEXCEPT;
    void GetGattIncludedServicesImpl(nn::sf::OutArray<user::GattService> pIncludedServices, nn::sf::Out<uint8_t> pOutNum, uint32_t connectionHandle, uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattCharacteristicsImpl(nn::sf::OutArray<user::GattCharacteristic> pCharacteristics, nn::sf::Out<uint8_t> pOutNum, uint32_t connectionHandle, uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattDescriptorsImpl(nn::sf::OutArray<user::GattDescriptor> pDescriptors, nn::sf::Out<uint8_t> pOutNum, uint32_t connectionHandle, uint16_t charHandle) NN_NOEXCEPT;

    bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result ConfigureBleMtuImpl(uint32_t connectionHandle, uint16_t mtu) NN_NOEXCEPT;
    void GetBleMtuImpl(nn::sf::Out<uint16_t> mtu, uint32_t connectionHandle) NN_NOEXCEPT;

    nn::Result RegisterBleGattDataPathImpl(user::BleDataPath path) NN_NOEXCEPT;
    nn::Result UnregisterBleGattDataPathImpl(user::BleDataPath path) NN_NOEXCEPT;

    nn::Result RegisterAppletResourceUserIdImpl(const nn::applet::AppletResourceUserId& aruid, uint32_t appletId) NN_NOEXCEPT;
    nn::Result UnregisterAppletResourceUserIdImpl(const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;
    nn::Result SetAppletResourceUserIdImpl(const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;
};

//アプリアボートをImplオブジェクトのデストラクタで取得するため、Systemのシェアードポインタはセッションごとにサーバー側で生成する
class BtmSystemImpl
{
private:
public:
    void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmSystemCore>> pOutService) NN_NOEXCEPT;
};

class BtmSystemCoreImpl
{
public:
    BtmSystemCoreImpl() NN_NOEXCEPT;
    ~BtmSystemCoreImpl() NN_NOEXCEPT;

    nn::Result StartGamepadPairingImpl() NN_NOEXCEPT;
    void CancelGamepadPairingImpl() NN_NOEXCEPT;
    void ClearGamepadPairingDatabaseImpl() NN_NOEXCEPT;
    void GetPairedGamepadCountImpl(nn::sf::Out<std::uint8_t> pPairedGamepadCount) NN_NOEXCEPT;
    void EnableRadioImpl() NN_NOEXCEPT;
    void DisableRadioImpl() NN_NOEXCEPT;
    void GetRadioOnOffImpl(nn::sf::Out<bool> pIsRadioOn) NN_NOEXCEPT;//[Todo]IsRadioEnabledImpleにする
    bool AcquireRadioEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle);
    bool AcquireGamepadPairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle);
    bool IsGamepadPairingStartedImpl();
private:
    uint8_t m_GamepadPairingEventId;
    uint8_t m_RadioEventId;
};

class BtmDebugImpl
{
private:
public:
    bool AcquireDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result StartDiscoveryImpl() NN_NOEXCEPT;
    nn::Result CancelDiscoveryImpl() NN_NOEXCEPT;
    void GetDevicePropertyImpl(nn::sf::Out<nn::btm::DevicePropertyList> pList) NN_NOEXCEPT;
    nn::Result CreateBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result CancelBondImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result SetTsiModeImpl(nn::btm::BdAddress bdAddress, nn::btm::TsiMode tsiMode) NN_NOEXCEPT;
    void GeneralTestImpl(int mode) NN_NOEXCEPT;
    void GeneralGetImpl(int mode, nn::sf::Out<nn::btm::GeneralInfoList> pList) NN_NOEXCEPT;
    void HidConnectImpl(nn::btm::BdAddress bdAddress) NN_NOEXCEPT;
    bool GetGattClientDisconnectionReasonImpl(nn::sf::Out<uint16_t> pOutReason, uint32_t connectionHandle, BdAddress address) NN_NOEXCEPT;
    bool GetBleConnectionParameterImpl(nn::sf::Out<uint16_t> pOutInterval, nn::sf::Out<uint16_t> pOutLatency, nn::sf::Out<uint16_t> pOutTimeout,
                                       uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetBleConnectionParameterRequestImpl(nn::sf::Out<uint16_t> pOutIntervalMin, nn::sf::Out<uint16_t> pOutIntervalMax,
                                              nn::sf::Out<uint16_t> pOutLatency, nn::sf::Out<uint16_t> pOutTimeout,
                                              uint32_t connectionHandle) NN_NOEXCEPT;
};

//アプリアボートをImplオブジェクトのデストラクタで取得するため、Systemのシェアードポインタはセッションごとにサーバー側で生成する
class BtmUserImpl
{
private:
public:
    void GetCoreImpl(nn::sf::Out<nn::sf::SharedPointer<nn::btm::IBtmUserCore>> pOutService) NN_NOEXCEPT;
};

class BtmUserCoreImpl
{
private:
    nn::applet::AppletResourceUserId m_BleConnectionOwner;
    nn::applet::AppletResourceUserId m_BleGeneralScanOwner;
    nn::applet::AppletResourceUserId m_BlePairedScanOwner;
    nn::applet::AppletResourceUserId m_BleSmartDeviceScanOwner;

    uint8_t m_BleScanEventId;
    uint8_t m_BleConnectionEventId;
    uint8_t m_BlePairingEventId;
    uint8_t m_BleServiceDiscoveryEventId;
    uint8_t m_BleMtuConfigEventId;
public:
    BtmUserCoreImpl() NN_NOEXCEPT;
    ~BtmUserCoreImpl() NN_NOEXCEPT;

    bool AcquireBleScanEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;

    nn::Result GetBleScanParameterGeneralImpl(nn::sf::Out<user::BleAdvFilterForGeneral> pFilter, uint16_t parameterId) NN_NOEXCEPT;
    nn::Result GetBleScanParameterSmartDeviceImpl(nn::sf::Out<user::BleAdvFilterForSmartDevice> pFilter, uint16_t parameterId) NN_NOEXCEPT;

    nn::Result StartBleScanForGeneralImpl(const nn::applet::AppletResourceUserId& aruid, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForGeneralImpl() NN_NOEXCEPT;
    void GetBleScanResultsForGeneralImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum,
                                         const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    nn::Result StartBleScanForPairedDeviceImpl(const nn::applet::AppletResourceUserId& aruid, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result StopBleScanForPairedDeviceImpl() NN_NOEXCEPT;

    nn::Result StartBleScanForSmartDeviceImpl(const nn::applet::AppletResourceUserId& aruid, user::BleAdvFilterForSmartDevice filter) NN_NOEXCEPT;
    nn::Result StopBleScanForSmartDeviceImpl() NN_NOEXCEPT;
    void GetBleScanResultsForSmartDeviceImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum,
                                             const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    //nn::Result RegisterBleStreetPassImpl(user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    //void UnregisterBleStreetPassImpl(user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    //void GetBleStreetPassResultsImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;

    //nn::Result RegisterBleSmartDeviceStreetPassImpl(user::BleAdvFilterForSmartDevice filter) NN_NOEXCEPT;
    //void UnregisterBleSmartDeviceStreetPassImpl(user::BleAdvFilterForSmartDevice filter) NN_NOEXCEPT;
    //void GetBleSmartDeviceStreetPassResultsImpl(nn::sf::OutArray<user::ScanResult> results, nn::sf::Out<uint8_t> pResultNum, user::BleAdvFilterForSmartDevice filter) NN_NOEXCEPT;

    bool AcquireBleConnectionEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;

    nn::Result BleConnectImpl(const nn::applet::AppletResourceUserId& aruid, BdAddress bdAddress) NN_NOEXCEPT;
    nn::Result BleDisconnectImpl(uint32_t connectionHandle) NN_NOEXCEPT;
    void BleGetConnectionStateImpl(nn::sf::OutArray<user::BleClientConnState> pConnState, nn::sf::Out<uint8_t> pOutNum,
                                   const nn::applet::AppletResourceUserId& aruid) NN_NOEXCEPT;

    bool AcquireBlePairingEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;

    nn::Result BleUnpairDeviceImpl(nn::btm::BdAddress bdAddress, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;

    nn::Result BlePairDeviceImpl(uint32_t connectionHandle, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;
    nn::Result BleUnpairDeviceOnBothImpl(uint32_t connectionHandle, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;

    void BleGetPairedAddressesImpl(nn::sf::OutArray<BdAddress> pAddresses, nn::sf::Out<uint8_t> pOutNum, user::BleAdvFilterForGeneral filter) NN_NOEXCEPT;

    bool AcquireBleServiceDiscoveryEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    void GetGattServicesImpl(nn::sf::OutArray<user::GattService> pServices, nn::sf::Out<uint8_t> pOutNum,
                             const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle) NN_NOEXCEPT;
    bool GetGattServiceImpl(nn::sf::Out<user::GattService> pService,
                            const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, const nn::bluetooth::GattAttributeUuid& uuid) NN_NOEXCEPT;
    bool GetBelongingServiceImpl(nn::sf::Out<user::GattService> pService,
                                 const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, uint16_t attributeHandle) NN_NOEXCEPT;
    void GetGattIncludedServicesImpl(nn::sf::OutArray<user::GattService> pIncludedServices, nn::sf::Out<uint8_t> pOutNum,
                                     const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattCharacteristicsImpl(nn::sf::OutArray<user::GattCharacteristic> pCharacteristics, nn::sf::Out<uint8_t> pOutNum,
                                    const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, uint16_t serviceHandle) NN_NOEXCEPT;
    void GetGattDescriptorsImpl(nn::sf::OutArray<user::GattDescriptor> pDescriptors, nn::sf::Out<uint8_t> pOutNum,
                                const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, uint16_t charHandle) NN_NOEXCEPT;

    bool AcquireBleMtuConfigEventImpl(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result ConfigureBleMtuImpl(const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle, uint16_t mtu) NN_NOEXCEPT;
    void GetBleMtuImpl(nn::sf::Out<uint16_t> mtu,
                       const nn::applet::AppletResourceUserId& aruid, uint32_t connectionHandle) NN_NOEXCEPT;

    nn::Result RegisterBleGattDataPathImpl(const nn::applet::AppletResourceUserId& aruid, user::BleDataPath path) NN_NOEXCEPT;
    nn::Result UnregisterBleGattDataPathImpl(const nn::applet::AppletResourceUserId& aruid, user::BleDataPath path) NN_NOEXCEPT;
};

}}  // namespace nn::btm

