﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

#include <nn/btm/user/btm_UserTypes.h>
#include <nn/bluetooth/bluetooth_BleScanParameterIdTestPeripheral.h>
#include <nn/bluetooth/bluetooth_BleScanParameterIdPalma.h>
#include <nn/bluetooth/bluetooth_BleScanParameterIdHoloholo.h>

namespace nn { namespace btm {

    typedef enum : uint8_t
    {
        BLE_SCAN_FILTER_TYPE_GENERAL = 0x01,
        BLE_SCAN_FILTER_TYPE_SMART_DEVICE = 0x02,
    } BleScanFilterType;

    struct BleScanFilterParameter
    {
        uint16_t            parameterId;
        BleScanFilterType   filterType;

        union
        {
            nn::btm::user::BleAdvFilterForGeneral       generalFilter;
            nn::btm::user::BleAdvFilterForSmartDevice   smartDeviceFilter;
        };
    };

    const BleScanFilterParameter BleScanFilterParameterList[] =
    {
        // PALMA
        {   nn::bluetooth::BleScanParameterId_Palma,
            BLE_SCAN_FILTER_TYPE_GENERAL,
            {
                .generalFilter.manufacturerId = { 0x53, 0x05 },
                .generalFilter.clientId = { 0xAD, 0xDE, 0x00 },
                .generalFilter.serverId = { 0xEF, 0xBE, 0x00 }
            }
        },
        // HOLOHOLO
        {   nn::bluetooth::BleScanParameterId_Holoholo,
            BLE_SCAN_FILTER_TYPE_SMART_DEVICE,
            {
                .smartDeviceFilter.length = nn::bluetooth::GattAttributeUuidLength_128,
                .smartDeviceFilter.uu.uuid128 = { 0x8F, 0x71, 0xDD, 0x81, 0xA2, 0x73, 0xF8, 0xB9, 0x7D, 0x48, 0x4F, 0x7E, 0x9A, 0x08, 0xC3, 0xB6 }
            }
        },
        // Test Peripheral
        {   nn::bluetooth::BleScanParameterId_TestPeripheral,
            BLE_SCAN_FILTER_TYPE_GENERAL,
            {
                .generalFilter.manufacturerId = { 0x53, 0x05 },
                .generalFilter.clientId = { 0x00, 0x01, 0x00 },
                .generalFilter.serverId = { 0x00, 0x01, 0x00 }
            }
        },
    };
}}  // namespace nn::btm
