﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "boot2_Maintenance.h"

#include <nn/util/util_ScopeExit.h>
#include <nn/bpc/bpc_PowerButton.h>
#include <nn/gpio/gpio.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/nn_SdkLog.h>

namespace nn { namespace boot2 {

    bool IsMaintenanceBoot()
    {
        bool forceMaintenance;
        settings::fwdbg::GetSettingsItemValue(&forceMaintenance, sizeof(forceMaintenance), "boot", "force_maintenance");
        if(forceMaintenance)
        {
            NN_SDK_LOG("[boot2] Force maintenance boot\n");
            return true;
        }

#if defined NN_BUILD_CONFIG_SPEC_NX
        gpio::Initialize();
        NN_UTIL_SCOPE_EXIT{ gpio::Finalize(); };

        gpio::GpioPadSession volDown;
        gpio::OpenSession(&volDown, gpio::GpioPadName_ButtonVolDn);
        NN_UTIL_SCOPE_EXIT{ gpio::CloseSession(&volDown); };
        gpio::SetDirection(&volDown, gpio::Direction_Input);

        gpio::GpioPadSession volUp;
        gpio::OpenSession(&volUp, gpio::GpioPadName_ButtonVolUp);
        NN_UTIL_SCOPE_EXIT{ gpio::CloseSession(&volUp); };
        gpio::SetDirection(&volUp, gpio::Direction_Input);

        if(gpio::GetValue(&volDown) == gpio::GpioValue_Low && gpio::GetValue(&volUp) == gpio::GpioValue_Low)
        {
            NN_SDK_LOG("[boot2] Maintenance boot\n");
            return true;
        }
#endif
        return false;
    }
}}  // namespace nn::boot2

