﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#define open(x,y,...) FileOpen(x,y)
#define remove(x) FileRemove(x)
#define write(x,y,z) FileWrite(x,(void *)y,z)
#define read(x,y,z) FileRead(x,y,z)
#define close(x) FileClose(x)
#define dprintf FilePrintf
#define app_file_size(x) FileSize(x)

#define mkdir(x) CreateDirectory(x)
#define rmdir(x) DeleteDirectory(x)
#define fgets(x,y,z) FileGets(x,y,z)


#ifdef __cplusplus
    #define FS_WRP_EXTERN_C extern "C"
    #define printf(format,...) NN_SDK_LOG(format,##__VA_ARGS__)
#else
    extern BOOLEAN silent_mode;
    #define FS_WRP_EXTERN_C extern
    #define printf(format,...)  \
do {    \
    if (!silent_mode) {     \
        NNC_SDK_LOG(format,##__VA_ARGS__);    \
    }    \
} while (0)
#endif


FS_WRP_EXTERN_C int FileOpen(const char * file_Name, int mode);
FS_WRP_EXTERN_C int FileRemove(const char *file);
FS_WRP_EXTERN_C int FileClose(int fd);
FS_WRP_EXTERN_C int FileWrite(int fd, const void* buffer, unsigned int size);
FS_WRP_EXTERN_C int FileRead(int fd, void* buffer, unsigned int size);
FS_WRP_EXTERN_C int FileSize(int fd);
FS_WRP_EXTERN_C int InitHostFileSystem(void);
FS_WRP_EXTERN_C void EndHostFileSystem(void);
FS_WRP_EXTERN_C int CreateDirectory(const char* name);
FS_WRP_EXTERN_C int DeleteDirectory(const char* name);
FS_WRP_EXTERN_C void FilePrintf(int fd, char *format, ...);
FS_WRP_EXTERN_C char* FileGets(char *data, unsigned short *len, int fd);
FS_WRP_EXTERN_C void FileBegine(int fd);
