﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include "fs_wrapper.h"

typedef void* FILE;

#if 0
#   define DEBUG_LOG(format,...) NN_SDK_LOG(format,##__VA_ARGS__)
#else
#   define DEBUG_LOG(format,...) (void*)0
#endif


#undef printf
extern "C" int printf(const char *FORMAT, ...)
{
    NN_SDK_LOG("Called the wrong printf! --------------------------------\n");
    return 0;
}

extern "C" int scanf(const char *FORMAT, ...)
{
    NN_SDK_LOG("Called the wrong scanf! ---------------------------------\n");
    return 0;
}

extern "C" FILE *fopen(const char* file, const char *mode)
{
    NN_SDK_LOG("Called the wrong fopen! ---------------------------------\n");
    return 0;
}

extern "C" int fclose(FILE *stream)
{
    NN_SDK_LOG("Called the wrong fclose! ---------------------------------\n");
    return 0;
}

extern "C" int unlink(const char *filename)
{
    NN_SDK_LOG("Called the wrong unlink! ---------------------------------\n");
    return 0;
}



extern "C" int FileOpen(const char * file_Name, int mode)
{
    DEBUG_LOG("%s %s\n", __func__, file_Name);
    return -1;
}

extern "C" int FileClose(int fd)
{
    DEBUG_LOG("%s\n", __func__);
    return 0;
}

extern "C" int FileWrite(int fd, const void *buffer, unsigned int size)
{
    DEBUG_LOG("%s\n", __func__);
    return 0;
}

extern "C" int FileRead(int fd, void* buffer, unsigned int size)
{
    DEBUG_LOG("%s\n", __func__);
    return 0;
}

extern "C" int FileSize(int fd)
{
    DEBUG_LOG("%s\n", __func__);
    return 0;
}

extern "C" int InitHostFileSystem()
{
    DEBUG_LOG("%s\n", __func__);
    return -1;
}

extern "C" void EndHostFileSystem()
{
    DEBUG_LOG("%s\n", __func__);
}

extern "C" int CreateDirectory(const char *name)
{
    DEBUG_LOG("%s %s\n", __func__, name);
    return -1;
}

extern "C" int DeleteDirectory(const char *name)
{
    DEBUG_LOG("%s %s\n", __func__, name);
    return -1;
}

extern "C" int FileRemove(const char *file_Name)
{
    DEBUG_LOG("%s %s\n", __func__, file_Name);
    return -1;
}

extern "C" void FilePrintf(int fd, char *format, ...)
{
    DEBUG_LOG("%s\n", __func__);
}

extern "C" char* FileGets(char *data, unsigned short *len, int fd)
{
    DEBUG_LOG("%s\n", __func__);
    *len = 0;
    return NULL;
}

extern "C" void FileBegine(int fd)
{
    DEBUG_LOG("%s\n", __func__);
}

