﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

/*!
    @brief      ニンテンドーアカウントキャッシュの更新スレッドです。
*/
class NintendoAccountCacheUpdateThread
{
public:
    /*!
        @brief      スレッドの実行を開始します。
    */
    static void Start() NN_NOEXCEPT;

    /*!
        @brief      スレッドの実行を停止します。
    */
    static void Stop() NN_NOEXCEPT;

    /*!
        @brief      ニンテンドーアカウントキャッシュの更新を要求します。
    */
    static void RequestNintendoAccountCacheUpdate() NN_NOEXCEPT;

    /*!
        @brief      システムが半起床状態になったことを通知します。
    */
    static void NotifySystemHalfAwaked() NN_NOEXCEPT;

    /*!
        @brief      システムが全起床状態になったことを通知します。
    */
    static void NotifySystemFullAwaked() NN_NOEXCEPT;

    /*!
        @brief      システムがスリープに入る準備を行ったことを通知します。

        @param[in]  isFromFullAwake 全起床状態からのスリープかどうか。
    */
    static void NotifySystemSleepReady(bool isFromFullAwake) NN_NOEXCEPT;
};
