﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "account_AccountDaemonSettings.h"

#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_MutexApi.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>

namespace nn {
namespace {

/* --------------------------------------------------------------------------------------------
    設定の定義 (Processes/account/!.nact, account.daemon.settings.fwdbg-*.yml 準拠)
 */
const char SettingName[] = "account.daemon";
const char BackgroundAwakingPeriodicityName[] = "background_awaking_periodicity";
const char SchedulePeriodicityName[]    = "schedule_periodicity";
const char ProfileSyncIntervalName[]    = "profile_sync_interval";
const char NaInfoRefreshIntervalName[]  = "na_info_refresh_interval";

inline int32_t LoadSettingValue(const char* key) NN_NOEXCEPT
{
    int32_t value;
    auto s = settings::fwdbg::GetSettingsItemValue(&value, sizeof(value), SettingName, key);
    NN_ABORT_UNLESS(s == sizeof(value));
    return value;
}

#define NN_ACCOUNT_DEFINE_VALUE(type, key) \
    type g_ ## key;

NN_ACCOUNT_DEFINE_VALUE(int32_t, BackgroundAwakingPeriodicity);
NN_ACCOUNT_DEFINE_VALUE(int32_t, SchedulePeriodicity);
NN_ACCOUNT_DEFINE_VALUE(int32_t, ProfileSyncInterval);
NN_ACCOUNT_DEFINE_VALUE(int32_t, NaInfoRefreshInterval);

#undef NN_ACCOUNT_DEFINE_VALUE

/* --------------------------------------------------------------------------------------------
    設定値の再読み込み
 */
void Refresh() NN_NOEXCEPT
{
#define NN_ACCOUNT_LOAD_SETTING_VALUE(key) \
    g_ ## key = LoadSettingValue(key ## Name)

    NN_ACCOUNT_LOAD_SETTING_VALUE(BackgroundAwakingPeriodicity);
    NN_ACCOUNT_LOAD_SETTING_VALUE(SchedulePeriodicity);
    NN_ACCOUNT_LOAD_SETTING_VALUE(ProfileSyncInterval);
    NN_ACCOUNT_LOAD_SETTING_VALUE(NaInfoRefreshInterval);

#undef NN_ACCOUNT_LOAD_SETTING_VALUE
}
} // ~namespace nn::account::detail::<anonymous>

AccountDaemonSettings LoadAccountDaemonSettings() NN_NOEXCEPT
{
    Refresh();
    AccountDaemonSettings v = {
        g_BackgroundAwakingPeriodicity,
        {
            g_SchedulePeriodicity,
            g_ProfileSyncInterval,
            g_NaInfoRefreshInterval,
        },
    };
    return v;
}

} // ~namespace nn
