﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "dmnt_DebugMonitor.h"
#include "dmnt_RspParser.h"
#include "dmnt_RspPacket.h"

namespace nn { namespace dmnt { namespace rsp {
#define SET(symbol, constant, name, string) symbol = constant

enum
{
    SET (GDB_SIGNAL_0,              0,  "0",                    "Signal 0"),
    SET (GDB_SIGNAL_INT,            2,  "SIGINT",               "Interrupt"),             // Ctrl-C
    SET (GDB_SIGNAL_ILL,            4,  "SIGILL",               "Illegal instruction"),   // Non-continuable
    SET (GDB_SIGNAL_TRAP,           5,  "SIGTRAP",              "Trace/breakpoint trap"), // Software break, single-step
    SET (GDB_SIGNAL_FPE,            8,  "SIGFPE",               "Arithmetic exception"),  // Div zero, floating point
    SET (GDB_SIGNAL_EMT,            7,  "SIGEMT",               "Emulation trap"),
    SET (GDB_SIGNAL_KILL,           9,  "SIGKILL",              "Killed"),
    SET (GDB_SIGNAL_BUS,           10,  "SIGBUS",               "Bus error"),
    SET (GDB_SIGNAL_SEGV,          11,  "SIGSEGV",              "Segmentation fault"), // access-violation
    SET (GDB_SIGNAL_SYS,           12,  "SIGSYS",               "Bad system call")
};

#undef SET
Result ProcessDebugEvent(bool* pReply, char* pReplyBuffer, DebugProcess *pDebugProcess);
}}}


