﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os.h>
namespace {
class MallocLock
{
public:
    MallocLock()
    {
        nn::os::InitializeMutex(&m_Mutex, false, 0);
    }
    ~MallocLock()
    {
        nn::os::FinalizeMutex(&m_Mutex);
    }
    void lock()
    {
        nn::os::LockMutex(&m_Mutex);
    }
    void unlock()
    {
        nn::os::UnlockMutex(&m_Mutex);
    }
private:
    nn::os::MutexType m_Mutex;
};
MallocLock g_MallocLock;
}

extern "C" void __malloc_lock()
{
    g_MallocLock.lock();
}
extern "C" void __malloc_unlock()
{
    g_MallocLock.unlock();
}
