﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/nn_Abort.h>
#include <nn/os.h>

#include <nn/sm/sm_UserApi.h>

#include <nn/htcs.h>
#include <nn/htcs/htcs_LibraryPrivate.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include "dmnt_Allocator.h"
#include "dmnt_GdbServer.h"
#include "dmnt_ServerMain.h"
#include "dmnt_Server.h"

#include <nn/nn_SdkLog.h>

extern "C" void nninitStartup()
{
}

extern "C" void nndiagStartup()
{
}

extern "C" void nnMain()
{
    nn::dmnt::alloc::Initialize();

    nn::sm::Initialize();

    StartServer();

    nn::htcs::Initialize(
        nn::dmnt::alloc::Allocate,
        nn::dmnt::alloc::Deallocate,
        4
    );

    Server::Initialize();
    nn::dmnt::gdbserver::Initialize();

    for (;;)
    {
        nn::os::SleepThread( nn::TimeSpan::FromMilliSeconds(1000) );
    }
}

