﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Abort.h>
#include <mutex>
#include <nn/os.h>
#include <nn/osdbg.h>
#include <nn/svc/svc_Base.h>
#include <nn/svc/svc_Dmnt.h>
#include <nn/svc/svc_Synchronization.h>
#include <nn/svc/svc_Result.h>
#include <nn/util/util_FormatString.h>
#include <nn/dmnt/dmnt_Result.h>
#include "dmnt_Rsp.h"
#include "dmnt_DebugMonitor.h"
#include <alloca.h>
#include <cstring>
#include "gdbserver_log.h"

#include "dmnt_ArraySize.h"
#include "BreakPointManagerBase.h"

namespace nn { namespace dmnt {

BreakPointManagerBase::BreakPointManagerBase(DebugProcess *debugProcess)
: m_pDebugProcess(debugProcess)
{
    GDB_TRACE_T("BreakPointManagerBase %s:%d this=0x%llx, debugProcess=0x%llx", __func__,__LINE__, this, debugProcess);
}

nn::Result BreakPointManagerBase::ClearBreakPoint(uintptr_t addr, size_t size)
{
    nn::Result result;
    for (unsigned i = 0; GetBreakPoint(i) != nullptr; ++i)
    {
        BreakPointBase *breakPoint(GetBreakPoint(i));
        if (breakPoint->m_InUse && breakPoint->m_Addr == addr)
        {
            NN_ABORT_UNLESS(breakPoint->m_Length == size);
            result = breakPoint->Clear(m_pDebugProcess);
            break;
        }
    }
    return result;
}

BreakPointBase *BreakPointManagerBase::GetFreeBreak()
{
    for (unsigned i = 0; GetBreakPoint(i) != nullptr; ++i)
    {
        BreakPointBase *breakPoint(GetBreakPoint(i));
        if (!breakPoint->m_InUse)
        {
            return breakPoint;
        }
    }
    return nullptr;
}

void BreakPointManagerBase::Reset()
{
    for (unsigned i = 0; GetBreakPoint(i) != nullptr; ++i)
    {
        BreakPointBase *breakPoint(GetBreakPoint(i));
        breakPoint->Reset();
    }
}

void BreakPointManagerBase::ClearAll()
{
    for (unsigned i = 0; GetBreakPoint(i) != nullptr; ++i)
    {
        BreakPointBase *breakPoint(GetBreakPoint(i));
        if (breakPoint->m_InUse)
        {
            breakPoint->Clear(m_pDebugProcess);
        }
    }
}

}}

