﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "xcd_VibrationAmFmEncoder.h"

namespace nn { namespace xcd {

const VibrationAmpFreqT::Type VibrationAmFmEncoder::MinAmp
    = VibrationPowTable::CalcPow(VibrationAmFmCommand::s_Config5bitVer2.logMinAmp);
const VibrationAmpFreqT::Type VibrationAmFmEncoder::MaxAmp
    = VibrationPowTable::CalcPow(VibrationAmFmCommand::s_Config5bitVer2.logMaxAmp);
const VibrationAmpFreqT::Type VibrationAmFmEncoder::MinFreq
    = VibrationPowTable::CalcPow(VibrationAmFmCommand::s_Config5bitVer2.logMinFreq);
const VibrationAmpFreqT::Type VibrationAmFmEncoder::MaxFreq
    = VibrationPowTable::CalcPow(VibrationAmFmCommand::s_Config5bitVer2.logMaxFreq);

const int VibrationAmFmEncoder::AbsAmIdxArray[] = {11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
const VibrationAmpFreqT::Type VibrationAmFmEncoder::AbsAmThresholdArray[] = {
    VibrationAmpFreqT::FromFloat(0.03772164f),
    VibrationAmpFreqT::FromFloat(0.05334664f),
    VibrationAmpFreqT::FromFloat(0.07544327f),
    VibrationAmpFreqT::FromFloat(0.10669327f),
    VibrationAmpFreqT::FromFloat(0.15088749f),
    VibrationAmpFreqT::FromFloat(0.21338749f),
    VibrationAmpFreqT::FromFloat(0.30177594f),
    VibrationAmpFreqT::FromFloat(0.42677594f),
    VibrationAmpFreqT::FromFloat(0.60355282f),
    VibrationAmpFreqT::FromFloat(0.85355282f),
};

const int VibrationAmFmEncoder::AbsFmIdxArray[] = {12, 13, 14, 15, 16};
const VibrationAmpFreqT::Type VibrationAmFmEncoder::AbsFmThresholdArray[] = {
    VibrationAmpFreqT::FromFloat(0.82461548f),
    VibrationAmpFreqT::FromFloat(0.93906212f),
    VibrationAmpFreqT::FromFloat(1.06939412f),
    VibrationAmpFreqT::FromFloat(1.21781350f),
};

const int VibrationAmFmEncoder::RelAmFmOffsetArrayA[] = {6, 3, 0, -3, -6};
const int VibrationAmFmEncoder::RelAmFmOffsetArrayF[] = {1, 0, -1};

const int VibrationAmFmEncoder::Am7bitIdxArray[] = {
    0,   1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,
    16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
    32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,
    48,  49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,
    64,  65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
    80,  81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,
    96,  97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
    112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
const VibrationAmpFreqT::Type VibrationAmFmEncoder::Am7bitThresholdArray[] = {
    VibrationAmpFreqT::FromFloat(0.00471497f),
    VibrationAmpFreqT::FromFloat(0.00604630f),
    VibrationAmpFreqT::FromFloat(0.00719071f),
    VibrationAmpFreqT::FromFloat(0.00855065f),
    VibrationAmpFreqT::FromFloat(0.01016903f),
    VibrationAmpFreqT::FromFloat(0.01209355f),
    VibrationAmpFreqT::FromFloat(0.01438141f),
    VibrationAmpFreqT::FromFloat(0.01710225f),
    VibrationAmpFreqT::FromFloat(0.02033902f),
    VibrationAmpFreqT::FromFloat(0.02418709f),
    VibrationAmpFreqT::FromFloat(0.02876378f),
    VibrationAmpFreqT::FromFloat(0.03420544f),
    VibrationAmpFreqT::FromFloat(0.04067803f),
    VibrationAmpFreqT::FromFloat(0.04837418f),
    VibrationAmpFreqT::FromFloat(0.05752755f),
    VibrationAmpFreqT::FromFloat(0.06388283f),
    VibrationAmpFreqT::FromFloat(0.06671143f),
    VibrationAmpFreqT::FromFloat(0.06966496f),
    VibrationAmpFreqT::FromFloat(0.07274914f),
    VibrationAmpFreqT::FromFloat(0.07597065f),
    VibrationAmpFreqT::FromFloat(0.07933426f),
    VibrationAmpFreqT::FromFloat(0.08284665f),
    VibrationAmpFreqT::FromFloat(0.08651448f),
    VibrationAmpFreqT::FromFloat(0.09034443f),
    VibrationAmpFreqT::FromFloat(0.09434414f),
    VibrationAmpFreqT::FromFloat(0.09852124f),
    VibrationAmpFreqT::FromFloat(0.10288334f),
    VibrationAmpFreqT::FromFloat(0.10743809f),
    VibrationAmpFreqT::FromFloat(0.11219502f),
    VibrationAmpFreqT::FromFloat(0.11716271f),
    VibrationAmpFreqT::FromFloat(0.12234974f),
    VibrationAmpFreqT::FromFloat(0.12636853f),
    VibrationAmpFreqT::FromFloat(0.12913514f),
    VibrationAmpFreqT::FromFloat(0.13196278f),
    VibrationAmpFreqT::FromFloat(0.13485241f),
    VibrationAmpFreqT::FromFloat(0.13780499f),
    VibrationAmpFreqT::FromFloat(0.14082337f),
    VibrationAmpFreqT::FromFloat(0.14390660f),
    VibrationAmpFreqT::FromFloat(0.14705754f),
    VibrationAmpFreqT::FromFloat(0.15027810f),
    VibrationAmpFreqT::FromFloat(0.15356827f),
    VibrationAmpFreqT::FromFloat(0.15693093f),
    VibrationAmpFreqT::FromFloat(0.16036797f),
    VibrationAmpFreqT::FromFloat(0.16387940f),
    VibrationAmpFreqT::FromFloat(0.16746808f),
    VibrationAmpFreqT::FromFloat(0.17113495f),
    VibrationAmpFreqT::FromFloat(0.17488194f),
    VibrationAmpFreqT::FromFloat(0.17871190f),
    VibrationAmpFreqT::FromFloat(0.18262482f),
    VibrationAmpFreqT::FromFloat(0.18662358f),
    VibrationAmpFreqT::FromFloat(0.19071007f),
    VibrationAmpFreqT::FromFloat(0.19488621f),
    VibrationAmpFreqT::FromFloat(0.19915391f),
    VibrationAmpFreqT::FromFloat(0.20351506f),
    VibrationAmpFreqT::FromFloat(0.20797158f),
    VibrationAmpFreqT::FromFloat(0.21252537f),
    VibrationAmpFreqT::FromFloat(0.21717930f),
    VibrationAmpFreqT::FromFloat(0.22193432f),
    VibrationAmpFreqT::FromFloat(0.22679425f),
    VibrationAmpFreqT::FromFloat(0.23176098f),
    VibrationAmpFreqT::FromFloat(0.23683548f),
    VibrationAmpFreqT::FromFloat(0.24202157f),
    VibrationAmpFreqT::FromFloat(0.24732113f),
    VibrationAmpFreqT::FromFloat(0.25273705f),
    VibrationAmpFreqT::FromFloat(0.25827122f),
    VibrationAmpFreqT::FromFloat(0.26392651f),
    VibrationAmpFreqT::FromFloat(0.26970578f),
    VibrationAmpFreqT::FromFloat(0.27561093f),
    VibrationAmpFreqT::FromFloat(0.28164673f),
    VibrationAmpFreqT::FromFloat(0.28781415f),
    VibrationAmpFreqT::FromFloat(0.29411603f),
    VibrationAmpFreqT::FromFloat(0.30055619f),
    VibrationAmpFreqT::FromFloat(0.30713749f),
    VibrationAmpFreqT::FromFloat(0.31386281f),
    VibrationAmpFreqT::FromFloat(0.32073594f),
    VibrationAmpFreqT::FromFloat(0.32775879f),
    VibrationAmpFreqT::FromFloat(0.33493615f),
    VibrationAmpFreqT::FromFloat(0.34226990f),
    VibrationAmpFreqT::FromFloat(0.34976483f),
    VibrationAmpFreqT::FromFloat(0.35742379f),
    VibrationAmpFreqT::FromFloat(0.36525059f),
    VibrationAmpFreqT::FromFloat(0.37324811f),
    VibrationAmpFreqT::FromFloat(0.38142109f),
    VibrationAmpFreqT::FromFloat(0.38977337f),
    VibrationAmpFreqT::FromFloat(0.39830876f),
    VibrationAmpFreqT::FromFloat(0.40703011f),
    VibrationAmpFreqT::FromFloat(0.41594315f),
    VibrationAmpFreqT::FromFloat(0.42505074f),
    VibrationAmpFreqT::FromFloat(0.43435860f),
    VibrationAmpFreqT::FromFloat(0.44386960f),
    VibrationAmpFreqT::FromFloat(0.45358944f),
    VibrationAmpFreqT::FromFloat(0.46352196f),
    VibrationAmpFreqT::FromFloat(0.47367096f),
    VibrationAmpFreqT::FromFloat(0.48404313f),
    VibrationAmpFreqT::FromFloat(0.49464226f),
    VibrationAmpFreqT::FromFloat(0.50547410f),
    VibrationAmpFreqT::FromFloat(0.51654244f),
    VibrationAmpFreqT::FromFloat(0.52785302f),
    VibrationAmpFreqT::FromFloat(0.53941155f),
    VibrationAmpFreqT::FromFloat(0.55122281f),
    VibrationAmpFreqT::FromFloat(0.56329346f),
    VibrationAmpFreqT::FromFloat(0.57562829f),
    VibrationAmpFreqT::FromFloat(0.58823205f),
    VibrationAmpFreqT::FromFloat(0.60111332f),
    VibrationAmpFreqT::FromFloat(0.61427594f),
    VibrationAmpFreqT::FromFloat(0.62772656f),
    VibrationAmpFreqT::FromFloat(0.64147187f),
    VibrationAmpFreqT::FromFloat(0.65551854f),
    VibrationAmpFreqT::FromFloat(0.66987229f),
    VibrationAmpFreqT::FromFloat(0.68454075f),
    VibrationAmpFreqT::FromFloat(0.69953061f),
    VibrationAmpFreqT::FromFloat(0.71484852f),
    VibrationAmpFreqT::FromFloat(0.73050118f),
    VibrationAmpFreqT::FromFloat(0.74649716f),
    VibrationAmpFreqT::FromFloat(0.76284314f),
    VibrationAmpFreqT::FromFloat(0.77954770f),
    VibrationAmpFreqT::FromFloat(0.79661751f),
    VibrationAmpFreqT::FromFloat(0.81406117f),
    VibrationAmpFreqT::FromFloat(0.83188630f),
    VibrationAmpFreqT::FromFloat(0.85010243f),
    VibrationAmpFreqT::FromFloat(0.86871720f),
    VibrationAmpFreqT::FromFloat(0.88774014f),
    VibrationAmpFreqT::FromFloat(0.90717888f),
    VibrationAmpFreqT::FromFloat(0.92704392f),
    VibrationAmpFreqT::FromFloat(0.94734288f),
    VibrationAmpFreqT::FromFloat(0.96808720f),
    VibrationAmpFreqT::FromFloat(0.98928547f),
};

const int VibrationAmFmEncoder::Fm7bitIdxArray[] = {
    1,   2,   3,   4,   5,   6,   7,   8,   9,   10,  11,  12,  13,  14,  15,  16,
    17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,  32,
    33,  34,  35,  36,  37,  38,  39,  40,  41,  42,  43,  44,  45,  46,  47,  48,
    49,  50,  51,  52,  53,  54,  55,  56,  57,  58,  59,  60,  61,  62,  63,  64,
    65,  66,  67,  68,  69,  70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,
    81,  82,  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  94,  95,  96,
    97,  98,  99,  100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
    113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127};
const VibrationAmpFreqT::Type VibrationAmFmEncoder::Fm7bitThresholdArray[] = {
    VibrationAmpFreqT::FromFloat(0.25827122f),
    VibrationAmpFreqT::FromFloat(0.26392651f),
    VibrationAmpFreqT::FromFloat(0.26970578f),
    VibrationAmpFreqT::FromFloat(0.27561093f),
    VibrationAmpFreqT::FromFloat(0.28164673f),
    VibrationAmpFreqT::FromFloat(0.28781415f),
    VibrationAmpFreqT::FromFloat(0.29411603f),
    VibrationAmpFreqT::FromFloat(0.30055619f),
    VibrationAmpFreqT::FromFloat(0.30713749f),
    VibrationAmpFreqT::FromFloat(0.31386281f),
    VibrationAmpFreqT::FromFloat(0.32073594f),
    VibrationAmpFreqT::FromFloat(0.32775879f),
    VibrationAmpFreqT::FromFloat(0.33493615f),
    VibrationAmpFreqT::FromFloat(0.34226990f),
    VibrationAmpFreqT::FromFloat(0.34976483f),
    VibrationAmpFreqT::FromFloat(0.35742379f),
    VibrationAmpFreqT::FromFloat(0.36525059f),
    VibrationAmpFreqT::FromFloat(0.37324811f),
    VibrationAmpFreqT::FromFloat(0.38142109f),
    VibrationAmpFreqT::FromFloat(0.38977337f),
    VibrationAmpFreqT::FromFloat(0.39830876f),
    VibrationAmpFreqT::FromFloat(0.40703011f),
    VibrationAmpFreqT::FromFloat(0.41594315f),
    VibrationAmpFreqT::FromFloat(0.42505074f),
    VibrationAmpFreqT::FromFloat(0.43435860f),
    VibrationAmpFreqT::FromFloat(0.44386960f),
    VibrationAmpFreqT::FromFloat(0.45358944f),
    VibrationAmpFreqT::FromFloat(0.46352196f),
    VibrationAmpFreqT::FromFloat(0.47367096f),
    VibrationAmpFreqT::FromFloat(0.48404313f),
    VibrationAmpFreqT::FromFloat(0.49464226f),
    VibrationAmpFreqT::FromFloat(0.50547410f),
    VibrationAmpFreqT::FromFloat(0.51654244f),
    VibrationAmpFreqT::FromFloat(0.52785302f),
    VibrationAmpFreqT::FromFloat(0.53941155f),
    VibrationAmpFreqT::FromFloat(0.55122281f),
    VibrationAmpFreqT::FromFloat(0.56329346f),
    VibrationAmpFreqT::FromFloat(0.57562829f),
    VibrationAmpFreqT::FromFloat(0.58823205f),
    VibrationAmpFreqT::FromFloat(0.60111332f),
    VibrationAmpFreqT::FromFloat(0.61427594f),
    VibrationAmpFreqT::FromFloat(0.62772656f),
    VibrationAmpFreqT::FromFloat(0.64147187f),
    VibrationAmpFreqT::FromFloat(0.65551854f),
    VibrationAmpFreqT::FromFloat(0.66987229f),
    VibrationAmpFreqT::FromFloat(0.68454075f),
    VibrationAmpFreqT::FromFloat(0.69953061f),
    VibrationAmpFreqT::FromFloat(0.71484852f),
    VibrationAmpFreqT::FromFloat(0.73050118f),
    VibrationAmpFreqT::FromFloat(0.74649716f),
    VibrationAmpFreqT::FromFloat(0.76284314f),
    VibrationAmpFreqT::FromFloat(0.77954770f),
    VibrationAmpFreqT::FromFloat(0.79661751f),
    VibrationAmpFreqT::FromFloat(0.81406117f),
    VibrationAmpFreqT::FromFloat(0.83188630f),
    VibrationAmpFreqT::FromFloat(0.85010243f),
    VibrationAmpFreqT::FromFloat(0.86871720f),
    VibrationAmpFreqT::FromFloat(0.88774014f),
    VibrationAmpFreqT::FromFloat(0.90717888f),
    VibrationAmpFreqT::FromFloat(0.92704392f),
    VibrationAmpFreqT::FromFloat(0.94734288f),
    VibrationAmpFreqT::FromFloat(0.96808720f),
    VibrationAmpFreqT::FromFloat(0.98928547f),
    VibrationAmpFreqT::FromFloat(1.01094819f),
    VibrationAmpFreqT::FromFloat(1.03308487f),
    VibrationAmpFreqT::FromFloat(1.05570698f),
    VibrationAmpFreqT::FromFloat(1.07882405f),
    VibrationAmpFreqT::FromFloat(1.10244656f),
    VibrationAmpFreqT::FromFloat(1.12658692f),
    VibrationAmpFreqT::FromFloat(1.15125657f),
    VibrationAmpFreqT::FromFloat(1.17646504f),
    VibrationAmpFreqT::FromFloat(1.20222664f),
    VibrationAmpFreqT::FromFloat(1.22855187f),
    VibrationAmpFreqT::FromFloat(1.25545407f),
    VibrationAmpFreqT::FromFloat(1.28294468f),
    VibrationAmpFreqT::FromFloat(1.31103802f),
    VibrationAmpFreqT::FromFloat(1.33974553f),
    VibrationAmpFreqT::FromFloat(1.36908246f),
    VibrationAmpFreqT::FromFloat(1.39906121f),
    VibrationAmpFreqT::FromFloat(1.42969704f),
    VibrationAmpFreqT::FromFloat(1.46100331f),
    VibrationAmpFreqT::FromFloat(1.49299527f),
    VibrationAmpFreqT::FromFloat(1.52568722f),
    VibrationAmpFreqT::FromFloat(1.55909539f),
    VibrationAmpFreqT::FromFloat(1.59323502f),
    VibrationAmpFreqT::FromFloat(1.62812233f),
    VibrationAmpFreqT::FromFloat(1.66377354f),
    VibrationAmpFreqT::FromFloat(1.70020581f),
    VibrationAmpFreqT::FromFloat(1.73743535f),
    VibrationAmpFreqT::FromFloat(1.77548028f),
    VibrationAmpFreqT::FromFloat(1.81435776f),
    VibrationAmpFreqT::FromFloat(1.85408783f),
    VibrationAmpFreqT::FromFloat(1.89468670f),
    VibrationAmpFreqT::FromFloat(1.93617440f),
    VibrationAmpFreqT::FromFloat(1.97857190f),
    VibrationAmpFreqT::FromFloat(2.02189637f),
    VibrationAmpFreqT::FromFloat(2.06617070f),
    VibrationAmpFreqT::FromFloat(2.11141396f),
    VibrationAmpFreqT::FromFloat(2.15764809f),
    VibrationAmpFreqT::FromFloat(2.20489407f),
    VibrationAmpFreqT::FromFloat(2.25317479f),
    VibrationAmpFreqT::FromFloat(2.30251313f),
    VibrationAmpFreqT::FromFloat(2.35293103f),
    VibrationAmpFreqT::FromFloat(2.40445424f),
    VibrationAmpFreqT::FromFloat(2.45710469f),
    VibrationAmpFreqT::FromFloat(2.51090813f),
    VibrationAmpFreqT::FromFloat(2.56589032f),
    VibrationAmpFreqT::FromFloat(2.62207604f),
    VibrationAmpFreqT::FromFloat(2.67949200f),
    VibrationAmpFreqT::FromFloat(2.73816491f),
    VibrationAmpFreqT::FromFloat(2.79812336f),
    VibrationAmpFreqT::FromFloat(2.85939408f),
    VibrationAmpFreqT::FromFloat(2.92200661f),
    VibrationAmpFreqT::FromFloat(2.98599053f),
    VibrationAmpFreqT::FromFloat(3.05137444f),
    VibrationAmpFreqT::FromFloat(3.11819077f),
    VibrationAmpFreqT::FromFloat(3.18647099f),
    VibrationAmpFreqT::FromFloat(3.25624562f),
    VibrationAmpFreqT::FromFloat(3.32754803f),
    VibrationAmpFreqT::FromFloat(3.40041161f),
    VibrationAmpFreqT::FromFloat(3.47487069f),
    VibrationAmpFreqT::FromFloat(3.55096055f),
    VibrationAmpFreqT::FromFloat(3.62871647f),
    VibrationAmpFreqT::FromFloat(3.70817566f),
    VibrationAmpFreqT::FromFloat(3.78937340f),
    VibrationAmpFreqT::FromFloat(3.87234974f),
};

}} // namespace nn::xcd
