﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


#pragma once

namespace nn { namespace xcd {

const uint32_t OtaSerialFlashSectorSize        = 0x1000;            //!< Serial Flash のセクタサイズ

const uint32_t OtaAddress_SerialFlashOffset    = 0xf8000000;        //!< Serial Flash のアドレスに対するオフセット
const uint32_t OtaAddress_FailsafeSection      = 0x1000;            //!< Failsafe Section の開始アドレス
const uint32_t OtaSize_FailsafeSection         = 0x1000;            //!< Failsafe Section のサイズ
const uint32_t OtaAddress_Ds2Offset            = 0x1ffc;            //!< Ds2 のオフセットが格納されたアドレス
const uint32_t OtaSize_Ds2Offset               = 0x04;              //!< Ds2 のオフセットが格納された領域のサイズ
const uint32_t OtaAddress_Signature            = 0x1ff4;            //!< Ds2 を利用するかどうか判定するための Signature が格納されたアドレス
const uint32_t OtaSize_Signature               = 0x08;              //!< Ds2 を利用するかどうか判定するための Signature が格納された領域のサイズ

const uint32_t OtaWriteSizeMax                 = 256;               //!< 1回あたりの Write コマンドにおける最大長
const uint32_t OtaReadSizeMax                  = 256;               //!< 1回あたりの Read コマンドにおける最大長

enum OtaDynamicSectionIndex
{
    OtaDynamicSectionIndex_1 = 0,                                   //!< Dynamic Section 1 用の Index
    OtaDynamicSectionIndex_2 = 1,                                   //!< Dynamic Section 2 用の Index
};
const uint32_t OtaAddress_DynamicSection[] = { 0x10000, 0x28000 };  //!< Dynamic Section の開始アドレス
const uint32_t OtaSize_DynamicSection = 0x18000;                    //!< Dynamic Section のサイズ

const uint8_t OtaSignature[] = { 0xAA, 0x55, 0xF0, 0x0F, 0x68, 0xE5, 0x97, 0xD2 };   //!< Dynamic Section 2 が使用されている際に Failsafe Section に書き込まれる Signature

}} // namespace nn::xcd
