﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_LightEventTypes.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/gpio/gpio.h>
#include "../xcd_IEventTask.h"
#include "../xcd_MultiWaitEvent.h"
#include "../xcd_TaskManager.h"

namespace nn { namespace xcd { namespace detail{

class GpioMonitorTask final : public IEventTask
{
private:
    //!< GPIO の割り込みを待ち受けるイベント
    nn::os::SystemEventType m_Event;

    // GPIO 用のセッション
    nn::gpio::GpioPadSession m_GpioSession;

    // GPIO の変化を通知するための イベント
    nn::os::LightEventType* m_pUpdateEvent;

    // 監視する GPIO
    nn::gpio::GpioPadName m_PadName;

    // Gpio が有効になっているかどうか
    bool m_IsGpioEnabled;

public:
    explicit GpioMonitorTask(nn::gpio::GpioPadName padName) NN_NOEXCEPT;
    virtual ~GpioMonitorTask() NN_NOEXCEPT NN_OVERRIDE;

    bool Activate(nn::os::LightEventType* pEvent, int debounceMsec = 0) NN_NOEXCEPT;
    void Deactivate() NN_NOEXCEPT;

    //!< Eventが通知された際に呼ばれる関数
    virtual void EventFunction(const ::nn::os::MultiWaitHolderType* pMultiWaitHolder) NN_NOEXCEPT NN_OVERRIDE;

    //!< 定常的な処理を行う関数
    virtual void PeriodicEventFunction() NN_NOEXCEPT NN_OVERRIDE;

    //!< 現在の Gpio の状態を取得
    bool IsLow() NN_NOEXCEPT;
};

}}} // namespace nn::xcd::detail
