﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_ObjectFactory.h>
#include "xcd_CreateSystemServer.h"
#include "xcd_SystemServerImpl.h"

namespace nn { namespace xcd { namespace detail {

namespace {

// 実装クラス SystemServerImpl を ISystemServer オブジェクトとして参照するためのサービスオブジェクト
nn::sf::UnmanagedServiceObject<ISystemServer, SystemServerImpl> g_SystemServer;

}  // anonymous namespace

nn::sf::SharedPointer<ISystemServer> CreateSystemServerByDfc() NN_NOEXCEPT
{
    // サービスオブジェクトの共有ポインタを取得
    return g_SystemServer.GetShared();
}

}}} // namespace nn::xcd::detail
