﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/bluetooth/bluetooth_LeTypes.h>

namespace nn { namespace xcd { namespace detail{

class BleGattUuidBase
{
private:
    BleGattUuidBase() NN_NOEXCEPT;

public:
    explicit BleGattUuidBase(uint16_t uuid16) NN_NOEXCEPT
    {
        Uuid.length = nn::bluetooth::GattAttributeUuidLength_16;
        Uuid.uu.uuid16 = uuid16;
    };
    explicit BleGattUuidBase(uint32_t uuid32) NN_NOEXCEPT
    {
        Uuid.length = nn::bluetooth::GattAttributeUuidLength_32;
        Uuid.uu.uuid32 = uuid32;
    };
    explicit BleGattUuidBase(const uint8_t uuid128[nn::bluetooth::GattAttributeUuidLength_128]) NN_NOEXCEPT
    {
        Uuid.length = nn::bluetooth::GattAttributeUuidLength_128;
        for (int i = 0; i < nn::bluetooth::GattAttributeUuidLength_128; ++i)
        {
            Uuid.uu.uuid128[i] = uuid128[i];
        }
    };
    virtual ~BleGattUuidBase() NN_NOEXCEPT { /* 何もしない */ };

    nn::bluetooth::GattAttributeUuid Uuid;
};

//!< Nintendo Hid over Gatt Service を表す UUID
const uint8_t NhogUuid128[16] = {0xE5, 0x23, 0x7A, 0xE2, 0x51, 0x6B, 0x55, 0xBB, 0x67, 0x45, 0x6D, 0xF3, 0x6C, 0xE1, 0x75, 0x66};
const BleGattUuidBase NhogService(NhogUuid128);

//!< Input Report を表す UUID
const uint8_t InputReportUuid128[16] = {0xE6, 0x23, 0x7A, 0xE2, 0x51, 0x6B, 0x55, 0xBB, 0x67, 0x45, 0x6D, 0xF3, 0x6C, 0xE1, 0x75, 0x66};
const BleGattUuidBase InputReportCharacteristic(InputReportUuid128);

//!< Output Command を表す UUID
const uint8_t OutputCommandUuid128[16] = {0xE7, 0x23, 0x7A, 0xE2, 0x51, 0x6B, 0x55, 0xBB, 0x67, 0x45, 0x6D, 0xF3, 0x6C, 0xE1, 0x75, 0x66};
const BleGattUuidBase OutputCommandCharacteristic(OutputCommandUuid128);

//!< Command Response を表す UUID
const uint8_t CommandResponseUuid128[16] = {0xE8, 0x23, 0x7A, 0xE2, 0x51, 0x6B, 0x55, 0xBB, 0x67, 0x45, 0x6D, 0xF3, 0x6C, 0xE1, 0x75, 0x66};
const BleGattUuidBase CommandResponseCharacteristic(CommandResponseUuid128);

//!< Client Characteristic Configuration を表す UUID
const BleGattUuidBase ClientConfigDescriptor(static_cast<uint16_t>(0x2902));

//!< Report Reference を表す UUID
const BleGattUuidBase ReportReferenceDescriptor(static_cast<uint16_t>(0x2908));

//!< Nintendo Battery Service を表す UUID
const uint8_t NbatUuid128[16] = { 0x45, 0xCE, 0xF8, 0x89, 0xAF, 0x8E, 0x07, 0x84, 0x66, 0x44, 0x04, 0x73, 0x7C, 0x7F, 0xBE, 0x2B };
const BleGattUuidBase NbatService(NbatUuid128);

//!< Battery Level を表す UUID
const uint8_t BatteryLevelUuid128[16] = { 0x46, 0xCE, 0xF8, 0x89, 0xAF, 0x8E, 0x07, 0x84, 0x66, 0x44, 0x04, 0x73, 0x7C, 0x7F, 0xBE, 0x2B };
const BleGattUuidBase BatteryLevelCharacteristic(BatteryLevelUuid128);

//!< Battery State を表す UUID
const uint8_t BatteryStateUuid128[16] = { 0x47, 0xCE, 0xF8, 0x89, 0xAF, 0x8E, 0x07, 0x84, 0x66, 0x44, 0x04, 0x73, 0x7C, 0x7F, 0xBE, 0x2B };
const BleGattUuidBase BatteryStateCharacteristic(BatteryStateUuid128);

}}} // namespace nn::xcd::detail
