﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   Aardvark ラッパーライブラリの SPI 機能の API 宣言です。
 */

#pragma once

#include <nn/nn_Common.h>

#include "aardvark_Types.win32.h"

namespace nn { namespace xcd { namespace detail { namespace aardvark {

/**
 * @name    SPI の操作
 * @{
 */

int ConfigureSpi(DeviceHandle handle, const SpiConfig& config) NN_NOEXCEPT;

int SetSpiMode(DeviceHandle handle, SpiMode mode) NN_NOEXCEPT;

int GetSpiBitrate(DeviceHandle handle) NN_NOEXCEPT;

int SetSpiBitrate(DeviceHandle handle, int bitrateKhz) NN_NOEXCEPT;

int SetSpiMasterSsPolarity(DeviceHandle handle, SpiMasterSsPolarity polarity) NN_NOEXCEPT;

int ReadSpi(size_t* pOutDoneBytes, char* pOutReadData, size_t readDataBytes, DeviceHandle handle) NN_NOEXCEPT;

int WriteSpi(size_t* pReceivedBytes,
             char* pOutReceivedData,
             size_t receiveBytes,
             const char* pWriteData,
             size_t writeBytes,
             DeviceHandle handle) NN_NOEXCEPT;

//! @}

}}}}
