﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include "visrv_Config.h"
#include "visrv_ResourceIdManagement.h"

namespace nn{ namespace visrv{

    class ProcessHeapBlockManager
    {
    public:
        static const int BlockCountMax = ProcessHeapBlockCountMax;

        struct Entry
        {
            ResourceId blockId;
            void* pMemory;
            size_t size;
        };

    public:
        ProcessHeapBlockManager() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // @retval ResultInvalidRange
        // @retval ResultResourceLimit
        // @retval ResultOperationFailed
        nn::Result AllocateMemoryBlock(ResourceId* pOutBlockId, size_t size) NN_NOEXCEPT;

        // @retval ResultNotFound
        nn::Result FreeMemoryBlock(ResourceId blockId) NN_NOEXCEPT;

        nn::Result GetMemory(void** pOutMemory, size_t* pOutSize, ResourceId blockId) NN_NOEXCEPT;

    private:
        void AdjustMemoryHeapSizeImpl() NN_NOEXCEPT;

    private:
        nn::os::MutexType m_Mutex;
        size_t m_CurrentHeapSize;
        Entry m_EntryList[BlockCountMax];
    };

    extern ProcessHeapBlockManager g_ProcessHeapBlockManager;

}}
