﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_Log.h"

#if defined(NN_SDK_BUILD_DEVELOP) || defined(NN_SDK_BUILD_DEBUG)
#define NN_VISRV_PROCESS_ENABLE_TRACE
#endif

#define NN_VISRV_SCOPE_EXIT_UNLESS(cond, expr)  \
    NN_UTIL_SCOPE_EXIT {                        \
        if(!(cond)) {                           \
            expr;                               \
        }                                       \
    }

// 処理の開始を宣言する。
// 対応する NN_VISRV_PROCESS_SUCCESS() を書くこと。
#ifdef NN_VISRV_PROCESS_ENABLE_TRACE
#define NN_VISRV_PROCESS_START()    \
    bool nn_visrv_process_is_success = false;   \
    bool warning_NN_VISRV_PROCESS_SUCCESS_is_not_placed;    \
    const char* nn_visrv_process_funcname = __FUNCTION__;   \
    const char* nn_visrv_process_filepath = __FILE__;       \
    int         nn_visrv_process_lineno = __LINE__; \
    NN_VISRV_PROCESS_ROLLBACK(  \
        NN_VISRV_LOG_ERR(       \
            "ProcessTrace\n"  \
            "  Func: %s\n"      \
            "  File: %s(%d)\n", \
            nn_visrv_process_funcname,  \
            nn_visrv_process_filepath, nn_visrv_process_lineno  \
        );  \
    );
#else
#define NN_VISRV_PROCESS_START()    \
    bool nn_visrv_process_is_success = false;   \
    bool warning_NN_VISRV_PROCESS_SUCCESS_is_not_placed;
#endif


// 失敗した場合の巻き戻し処理を宣言する。
// NN_VISRV_PROCESS_SUCCESS() が呼び出された後でスコープを抜けた場合には実行されない。
// NN_VISRV_PROCESS_START() および NN_VISRV_PROCESS_SUCCESS() と同じスコープに書くこと。
// expr ... 巻き戻し処理の expression。裸のカンマ(,)を含む場合には括弧で括ること。
//          statement を書いても大抵期待通り動作する。ダメなときはラムダ式で expression にするなど。
#define NN_VISRV_PROCESS_ROLLBACK(expr) \
    NN_VISRV_SCOPE_EXIT_UNLESS(nn_visrv_process_is_success, expr)

#define NN_VISRV_PROCESS_SUCCESS()  \
    nn_visrv_process_is_success = true; \
    NN_UNUSED(warning_NN_VISRV_PROCESS_SUCCESS_is_not_placed);
