﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkLog.h>
#include "visrv_Config.h"

//#define NN_VISRV_ENABLE_MEMORY_DUMP 1

// base macro for information logs
#define NN_VISRV_LOG(...)          NN_SDK_LOG("[visrv]" __VA_ARGS__)
// base macro for error logs
#define NN_VISRV_LOG_ERR(...)      NN_SDK_LOG("[visrv][err]" __VA_ARGS__)
// base macro for warning logs
#define NN_VISRV_LOG_WARN(...)     NN_SDK_LOG("[visrv][warn]" __VA_ARGS__)

//-----------
// info log
//-----------

// Report Open/Close action of Dispaly/Layer
//#define NN_VISRV_LOG_OPENCLOSE(...) NN_VISRV_LOG(__VA_ARGS__)

// Report memory usage of allocators (this may be enabled with NN_VISRV_ENABLE_MEMORY_DUMP)
//#define NN_VISRV_LOG_MEM(...)      NN_VISRV_LOG("[mem]" __VA_ARGS__)

// Report Construction/Destruction of service ofjects and ClientObject
//#define NN_VISRV_LOG_LIFETIME(...) NN_VISRV_LOG("[lifetime]" __VA_ARGS__)

// Report IPC
//#define NN_VISRV_LOG_IPC(...)      NN_VISRV_LOG("[ipc]" __VA_ARGS__)

// Report verbose IPC that may be called every frame
//#define NN_VISRV_LOG_IPCV(...) NN_VISRV_LOG("[ipc]" __VA_ARGS__)

// Report relaying transaction between client and nvnflinger (This may output too many logs. Enable this only for focused debugging)
//#define NN_VISRV_LOG_RELAY(...)    NN_VISRV_LOG("[relay]" __VA_ARGS__)

// Report contents of transaction
//#define NN_VISRV_LOG_TRANSACTIONDUMP(...)   NN_VISRV_LOG("[trans]" __VA_ARGS__)

// Report presentation tracer
//#define NN_VISRV_LOG_PRESENTTRACE(...)   NN_VISRV_LOG("[prtrc]" __VA_ARGS__)

// Report system event splitting/relaying
//#define NN_VISRV_LOG_EVENT(...)    NN_VISRV_LOG("[event]" __VA_ARGS__)

// Report indirect layer actions except flipping
//#define NN_VISRV_LOG_INDIRECT(...)    NN_VISRV_LOG("[indrct]" __VA_ARGS__)

// Report indirect layer flipping (this may output may logs)
//#define NN_VISRV_LOG_INDIRECT_FLIP(...)    NN_VISRV_LOG("[indrct]" __VA_ARGS__)

// Report syncpoint wait
//#define NN_VISRV_LOG_SYNCPOINT(...) NN_VISRV_LOG("[syncpt]" __VA_ARGS__)

// Report frame buffer sharing actions
//#define NN_VISRV_LOG_FBSHARE(...) NN_VISRV_LOG("[fbshare]" __VA_ARGS__)

//-----------
// error log
//-----------
#define NN_VISRV_LOG_RELAY_ERR(...) NN_VISRV_LOG_ERR("[relay]" __VA_ARGS__)
#define NN_VISRV_LOG_INDIRECT_ERR(...) NN_VISRV_LOG_ERR("[indrct]" __VA_ARGS__)
#define NN_VISRV_LOG_SYNCPOINT_ERR(...) NN_VISRV_LOG_ERR("[syncpt]" __VA_ARGS__)
#define NN_VISRV_LOG_FBSHARE_ERR(...) NN_VISRV_LOG_ERR("[fbshare]" __VA_ARGS__)

//-----------
// warning log
//-----------
#define NN_VISRV_LOG_RELAY_WARN(...) NN_VISRV_LOG_WARN("[relay]" __VA_ARGS__)
#define NN_VISRV_LOG_INDIRECT_WARN(...) NN_VISRV_LOG_WARN("[indrct]" __VA_ARGS__)


//---------------------------------
// depending settings
#if defined(NN_VISRV_LOG_IPC) || defined(NN_VISRV_LOG_IPCV)
#define NN_VISRV_ENABLE_TRACE_IPC 1 // NOLINT(preprocessor/const)
#endif

//---------------------------------
// check dependency

#if defined(NN_VISRV_LOG_TRANSACTIONDUMP) && !defined(NN_VISRV_ENABLE_TOSTRING)
#error To dump transaction, define NN_VISRV_ENABLE_TOSTRING in visrv_Config.h
#endif

//---------------------------------
// empty definitions
#ifndef NN_VISRV_LOG
#define NN_VISRV_LOG(...)
#endif
#ifndef NN_VISRV_LOG_ERR
#define NN_VISRV_LOG_ERR(...)
#endif
#ifndef NN_VISRV_LOG_WARN
#define NN_VISRV_LOG_WARN(...)
#endif


#ifndef NN_VISRV_LOG_OPENCLOSE
#define NN_VISRV_LOG_OPENCLOSE(...)
#endif
#ifndef NN_VISRV_LOG_MEM
#define NN_VISRV_LOG_MEM(...)
#endif
#ifndef NN_VISRV_LOG_LIFETIME
#define NN_VISRV_LOG_LIFETIME(...)
#endif
#ifndef NN_VISRV_LOG_IPC
#define NN_VISRV_LOG_IPC(...)
#endif
#ifndef NN_VISRV_LOG_IPCV
#define NN_VISRV_LOG_IPCV(...)
#endif
#ifndef NN_VISRV_LOG_RELAY
#define NN_VISRV_LOG_RELAY(...)
#endif
#ifndef NN_VISRV_LOG_TRANSACTIONDUMP
#define NN_VISRV_LOG_TRANSACTIONDUMP(...)
#endif
#ifndef NN_VISRV_LOG_PRESENTTRACE
#define NN_VISRV_LOG_PRESENTTRACE(...)
#endif
#ifndef NN_VISRV_LOG_EVENT
#define NN_VISRV_LOG_EVENT(...)
#endif
#ifndef NN_VISRV_LOG_INDIRECT
#define NN_VISRV_LOG_INDIRECT(...)
#endif
#ifndef NN_VISRV_LOG_INDIRECT_FLIP
#define NN_VISRV_LOG_INDIRECT_FLIP(...)
#endif
#ifndef NN_VISRV_LOG_SYNCPOINT
#define NN_VISRV_LOG_SYNCPOINT(...)
#endif
#ifndef NN_VISRV_LOG_FBSHARE
#define NN_VISRV_LOG_FBSHARE(...)
#endif

#ifndef NN_VISRV_LOG_RELAY_ERR
#define NN_VISRV_LOG_RELAY_ERR(...)
#endif
#ifndef NN_VISRV_LOG_INDIRECT_ERR
#define NN_VISRV_LOG_INDIRECT_ERR(...)
#endif
#ifndef NN_VISRV_LOG_SYNCPOINT_ERR
#define NN_VISRV_LOG_SYNCPOINT_ERR(...)
#endif
#ifndef NN_VISRV_LOG_FBSHARE_ERR
#define NN_VISRV_LOG_FBSHARE_ERR(...)
#endif

#ifndef NN_VISRV_LOG_RELAY_WARN
#define NN_VISRV_LOG_RELAY_WARN(...)
#endif
#ifndef NN_VISRV_LOG_INDIRECT_WARN
#define NN_VISRV_LOG_INDIRECT_WARN(...)
#endif


//--------------------------------------------
// IPC tracer
//--------------------------------------------

#if defined(NN_VISRV_ENABLE_TRACE_IPC)
#define NN_VISRV_TRACE_IPC_IMPL2(macro,port,funcname)                       \
    auto traceThreadId = nn::os::GetThreadId(nn::os::GetCurrentThread());   \
    macro(port ":%s (tid=%d)\n", funcname, traceThreadId);       \
    NN_UNUSED(traceThreadId);                                               \
    auto traceTick0 = nn::os::GetSystemTick();                              \
    NN_UNUSED(traceTick0);                                                  \
    NN_UTIL_SCOPE_EXIT {                                                    \
        auto traceTick1 = nn::os::GetSystemTick();                          \
        NN_UNUSED(traceTick1);                                              \
        macro(port ":%s -> %lluus\n", funcname, (traceTick1 - traceTick0).ToTimeSpan().GetMicroSeconds());   \
    };
#define NN_VISRV_TRACE_IPC_IMPL(port,funcname)  NN_VISRV_TRACE_IPC_IMPL2(NN_VISRV_LOG_IPC,port,funcname)
#define NN_VISRV_TRACE_IPCV_IMPL(port,funcname) NN_VISRV_TRACE_IPC_IMPL2(NN_VISRV_LOG_IPCV,port,funcname)
#else
#define NN_VISRV_TRACE_IPC_IMPL(port,funcname)
#define NN_VISRV_TRACE_IPCV_IMPL(port,funcname)
#endif

// for vi:u
#define NN_VISRV_TRACE_IPC_U(func) NN_VISRV_TRACE_IPC_IMPL("u", #func)
#define NN_VISRV_TRACE_IPCV_U(func) NN_VISRV_TRACE_IPCV_IMPL("u", #func)
// for vi:s
#define NN_VISRV_TRACE_IPC_S(func) NN_VISRV_TRACE_IPC_IMPL("s", #func)
#define NN_VISRV_TRACE_IPCV_S(func) NN_VISRV_TRACE_IPCV_IMPL("s", #func)
// for vi:m
#define NN_VISRV_TRACE_IPC_M(func) NN_VISRV_TRACE_IPC_IMPL("m", #func)
#define NN_VISRV_TRACE_IPCV_M(func) NN_VISRV_TRACE_IPCV_IMPL("m", #func)
// for relay
#define NN_VISRV_TRACE_IPCV_R(func) NN_VISRV_TRACE_IPCV_IMPL("r", #func)
