﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include "../vi/vi_Config.h"
#include <nn/vi/fbshare/vi_SharedFrameBufferSize.h>
#include <nn/vi/fbshare/vi_SharedBufferConfig.h>
#include <nn/am/service/display/am_DisplayControlConfig.h>


#define NN_VISRV_RELAY_PORTNAME "dispdrv"
#define NN_VISRV_INDIRECT_DEFAULT_TRANSACTION_SERVICE_NAME "indrct"


// For W/A.
//   nvnflinger のルートの Binder オブジェクトのリレーを許可する場合このマクロを定義する。
//   vi プロセスによるチェックが十分に行えなくなるため、ワークアラウンドのためにのみ使用すること。
//#define NN_VISRV_PERMIT_RELAY_ZERO_HANDLE 1

// For development
//   文字列へのダンプを有効化する。
//#define NN_VISRV_ENABLE_TOSTRING 1

namespace nn{ namespace visrv{

    // Max number of process heap block
    static const int ProcessHeapBlockCountMax = 4;

    // Max number of client processes
    static const int ClientProcessCountMax = 64;

    // Max number of displays per client process
    static const int DisplayCountPerClientMax = 6; // >= nn::vi::DisplayCountMax
    NN_STATIC_ASSERT(DisplayCountPerClientMax >= nn::vi::DisplayCountMax);

    // Max number of layers per display
    static const int LayerCountPerDisplayMax = 2; // >= nn::vi::LayerCountPerDisplayMax
    NN_STATIC_ASSERT(LayerCountPerDisplayMax >= nn::vi::LayerCountPerDisplayMax);

    // Max number of presentation requests in queue
    static const int LayerPresentationQueueCapacity = 16;
    static const int LayerPresentationTracerCountMax = 1;

    static const int DisplayHotplugEventCountPerClientMax = 1;
    static const int DisplayVsyncEventCountPerClientMax = 1;
    static const int DisplayVsyncEventDebugCountPerClientMax = 1;
    static const int DisplayErrorReportEventCountPerClientMax = 1;
    static const int DisplayModeChangedEventCountPerClientMax = 1;

    static const int DisplayModeCountMax = 16;

    static const int DriverObjectPerClientMax = 4 * DisplayCountPerClientMax * LayerCountPerDisplayMax;

//-----------------------------------------------------
// Indirect Display (for swkbd-async etc.)
//-----------------------------------------------------
    static const int IndirectLayerCountMax = 8;       // IndirectLayer slot count on IndirectDisplay
    static const int IndirectLayerBufferCountMax = 16; // Maximum graphic buffer count per IndirectLayer
    static const int IndirectLayerCountPerClientMax = IndirectLayerCountMax;

    static const int IndirectLayerMapCopyContextCountMax = 4;

    // Enable support of transfer memory version of GetIndirectImage()
    static const bool IsIndirectLayerSupportTransferMemory = false;


    static const bool BreakOnIndirectLayerBroken = false;

//-----------------------------------------------------
// FrameBufferSharing
//-----------------------------------------------------

    static const size_t SharedBufferStaticStorageSize = nn::am::service::display::RequiredSystemSharedBufferStaticStorageSize;

    static const int SharedBufferCountMax         = 4; // Max number of global SharedBuffer instances
    static const int SharedLowLevelLayerCountMax  = 8; // Max number of global SharedLowLevelLayer instances
    static const int SharedClientLayerCountMax    = 8; // Max number of global SharedClientLayer instances

    static const int SharedBufferImporterCountMaxPerSharedBuffer = 8;     // Max number of importer clients per of SharedBuffer instance
    static const int SharedFrameBufferCountMaxPerSharedBuffer   = 16;     // Max number of frame buffers per SharedBuffer instance (max of nBuf)

    static const int SharedAttachedFrameBufferCountMinPerClientLayer = 1; // Min number of attached frame buffer per SharedClinetLayer instance (min of nWin)
    static const int SharedAttachedFrameBufferCountMaxPerClientLayer = 4; // Max number of attached frame buffer per SharedClinetLayer instance (max of nWin)

    static const int SharedLowLevelLayerCountMaxPerSharedBuffer = 8;      // Max number of bound ManagedLayer per SharedBuffer instance

    static const int SharedClientLayerCountMaxPerClient = 2;              // Max number of bound SharedClientLayer instances per client

//-----------------------------------------------------
// Local layer access
//-----------------------------------------------------
    static const size_t LocalParcelWorkspaceSize = 2 * 4096;

//-----------------------------------------------------
// MultiWait
//-----------------------------------------------------
    enum MultiWaitIndex : uintptr_t
    {
        // 0-2 are used by sf
        // -49 are reserved for sf

        MultiWaitIndex_SystemEventHandlerMin = 50,
        MultiWaitIndex_SystemEventHandlerMax = 99,

        MultiWaitIndex_IndirectMapCopyImageMin = 100,
        MultiWaitIndex_IndirectMapCopyImageMax = MultiWaitIndex_IndirectMapCopyImageMin + IndirectLayerMapCopyContextCountMax - 1,

        MultiWaitIndex_IndirectFlipMin = 150,
        MultiWaitIndex_IndirectFlipMax = 199,

        MultiWaitIndex_PresentationTracerMin = 200,
        MultiWaitIndex_PresentationTracerMax = 209,

        MultiWaitIndex_SharedLowLevelLayerMin = 300,
        MultiWaitIndex_SharedLowLevelLayerMax = 499,

        MultiWaitIndex_SharedClientLayerMin =  500,
        MultiWaitIndex_SharedClientLayerMax =  599,

        MultiWaitIndex_LocalRequestQueue = 600,
    };

}}
