﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace visrv{ namespace vic{

    enum VicImageFormat
    {
        // R8G8B8A8-Packed-Pitch
        //
        // Layout:
        //   Plane0: 4 x W x H bytes
        //     R(0,0) G(0,0) B(0,0) A(0,0) R(1,0) G(1,0) B(1,0) A(1,0) ... R(W-1,0) G(W-1,0) B(W-1,0) A(W-1,0)
        //     R(0,1) G(0,1) B(0,1) A(0,1) R(1,1) G(1,1) B(1,1) A(1,1) ... R(W-1,1) G(W-1,1) B(W-1,1) A(W-1,1)
        //       ...
        //     R(0,H-1) G(0,H-1) B(0,H-1) A(0,H-1)      ...        R(W-1,H-1) G(W-1,H-1) B(W-1,H-1) A(W-1,H-1)
        VicImageFormat_Rgba8,
    };

}}}
