﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "visrv_VicConfig.h"
#include "visrv_VicModule.h"
#include "visrv_VicMemoryPool.h"
#include "visrv_VicImageFormat.h"

#include <nvrm_surface.h>

namespace nn{ namespace visrv{ namespace vic{

    struct VicImageBufferInfo
    {
        int width;
        int height;
        VicImageFormat format;
    };

    class VicImageBuffer
    {
    public:
        typedef VicImageBufferInfo InfoType;
    public:
        static size_t GetRequiredMemorySize(const InfoType& info) NN_NOEXCEPT;
        static size_t GetRequiredMemoryAlignment(VicModule* pModule, const InfoType& info) NN_NOEXCEPT;

        VicImageBuffer() NN_NOEXCEPT;

        nn::Result Initialize(VicModule* pModule, const InfoType& info, VicMemoryPool* pMemoryPool, ptrdiff_t offset, size_t size) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        int GetWidth() const NN_NOEXCEPT;
        int GetHeight() const NN_NOEXCEPT;
        VicImageFormat GetImageFormat() const NN_NOEXCEPT;
        size_t GetStride() const NN_NOEXCEPT;

        const NvRmSurface* GetSurface() const NN_NOEXCEPT;
        NvRmSurface* GetSurface() NN_NOEXCEPT;

        void FlushCache() const NN_NOEXCEPT;

    private:
        InfoType    m_Info;
        NvRmSurface m_Surface;

        VicMemoryPool* m_pMemoryPool;
        ptrdiff_t      m_Offset;
        size_t         m_Size;
    };

}}}
