﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "visrv_TNullableContainer.h"

namespace nn{ namespace visrv{ namespace util{

    namespace detail
    {
        template<typename T>
        class TNullPointerValue
        {
        public:
            static T* Get() NN_NOEXCEPT
            {
                return nullptr;
            }
        };
    }

    template<typename T, int TSize, int TThreadSafetyOption>
    class TPointerContainer
        : public TNullableContainer<T*, TSize, detail::TNullPointerValue<T>, TThreadSafetyOption>
    {
    };

}}}

