﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Applet;

namespace nn.vi
{
    [CppRefPath("<nn/vi/vi_Types.h>")]
    [ExternalStruct(96, 8)]
    public struct DisplayInfo { }

    [CppRefPath("<nn/vi/vi_DisplayModeInfo.h>")]
    [ExternalStruct(16, 8)]
    public struct DisplayModeInfo { }

    //------------------
    // fixed-size typedefs
    //------------------

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct CmuModeType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct ContentTypeType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct HotplugStateType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct LayerStackType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct PixelFormatType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct PowerStateType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct RgbRangeType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct ScalingModeType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct StereoModeType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct LayerSettingsType { }

    //------------------
    // private types
    //------------------

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct DisplayId { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct LayerId { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(64, 1)]
    public struct DisplayName { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 1)]
    public struct ProxyName { }

    [CppRefPath("<nn/vi/sf/vi_PolicyLevel.h>")]
    [ExternalStruct(4, 4)]
    public struct PolicyLevelType { }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectLayerHandleType{ }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectProducerHandleType{ }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct IndirectConsumerHandleType{ }

    [CppRefPath("<nn/vi/vi_LayerStack.h>")]
    [ExternalStruct(4, 4)]
    public struct LayerStackFlagType { }

    [CppRefPath("<nn/vi/vi_CropRegion.h>")]
    [ExternalStruct(16, 4)]
    public struct CropRegion { }

    [CppRefPath("<nn/vi/vi_ImageTransform.h>")]
    [ExternalStruct(4, 4)]
    public struct ImageTransformType { }

    [CppRefPath("<nn/vi/vi_DisplayError.h>")]
    [LargeData(true)]
    public struct CompositorError
    {
        [FixedArray(4096)]
        public char_t[] buffer;
    }

    [CppRefPath("<nn/vi/sf/vi_ServiceTypes.h>")]
    [ExternalStruct(12, 4)]
    public struct LayerConfig{ }
}

namespace nn.vi.native
{
    [CppRefPath("<nn/vi/native/vi_NativeType.h>")]
    [ExternalStruct(4, 4)]
    public struct NativeMemoryHandleId { }

    [CppRefPath("<nn/vi/native/vi_NativeType.h>")]
    [ExternalStruct(36, 4)]
    public struct NativeSync { }
}

namespace nn.vi.fbshare
{
    [CppRefPath("<nn/vi/fbshare/vi_SharedBufferHandle.h>")]
    [ExternalStruct(8, 8)]
    public struct SharedBufferHandle { }

    [CppRefPath("<nn/vi/fbshare/vi_SharedLayerHandle.h>")]
    [ExternalStruct(8, 8)]
    public struct SharedLayerHandle { }

    [CppRefPath("<nn/vi/fbshare/vi_SharedLayerTextureIndexList.h>")]
    [ExternalStruct(16, 4)]
    public struct SharedLayerTextureIndexList { }

    [CppRefPath("<nn/vi/fbshare/vi_SharedMemoryPoolLayout.h>")]
    [ExternalStruct(392, 8)]
    [LargeData]
    [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
    public struct SharedMemoryPoolLayout { }

    [CppRefPath("<nn/vi/fbshare/vi_SharedTextureOption.h>")]
    [ExternalStruct(16, 4)]
    public struct SharedTextureOption { }
}

namespace nn
{
    [ExternalStruct(8, 8)]
    [CppRefPath("<nn/nn_TimeSpan.h>")]
    public struct TimeSpan
    {
    }
}

namespace nn.applet
{
    [CppRefPath("<nn/applet/applet.h>")]
    [ExternalStruct(8, 8)]
    public struct AppletResourceUserId
    {
    }

    [CppRefPath("<nn/applet/applet.h>")]
    [CheckAppletResourceUserId]
    [CppFullName("nn::applet::AppletResourceUserId")]
    [ExternalStruct(8, 8)]
    public struct CheckedAppletResourceUserId
    {
    }
}

namespace nns.hosbinder
{
    [CppRefPath("<nn/vi/sf/hosbinder_IHOSBinderDriver.sfdl.h>")]
    public interface IHOSBinderDriver : IServiceObject
    {
    }
}

namespace nn.visrv.sf
{

    // service root for applications
    public interface IApplicationRootService : IServiceObject
    {
        [MethodId(0)]
        Result GetDisplayService(
            Out<IApplicationDisplayService> outService,
            vi.PolicyLevelType policyLevel
            );
    }

    // service root for system applications
    public interface ISystemRootService : IServiceObject
    {
        [MethodId(1)]
        Result GetDisplayService(
            Out<IApplicationDisplayService> outService,
            vi.PolicyLevelType policyLevel
            );

        [MethodId(3)]
        Result GetDisplayServiceWithProxyNameExchange(
            Out<IApplicationDisplayService> outService,
            vi.PolicyLevelType policyLevel,
            vi.ProxyName proxyName
            );
    }

    // service root for manager process (applet manager)
    public interface IManagerRootService : IServiceObject
    {
        [MethodId(2)]
        Result GetDisplayService(
            Out<IApplicationDisplayService> outService,
            vi.PolicyLevelType policyLevel
            );

        [MethodId(3)]
        Result GetDisplayServiceWithProxyNameExchange(
            Out<IApplicationDisplayService> outService,
            vi.PolicyLevelType policyLevel,
            vi.ProxyName proxyName
            );
    }

    //--------------------
    // Root
    //--------------------
    // IApplicationRootService
    // 0000: GetDisplayService                          u:NX Addon 0.11.x
    // ISystemRootService
    // 0001: GetDisplayService                          s:NX Addon 0.11.x
    // 0003: GetDisplayServiceWithProxyNameExchange     s:NX Addon 0.11.x
    // IManagerRootService
    // 0002: GetDisplayService                          m:NX Addon 0.11.x
    // 0003: GetDisplayServiceWithProxyNameExchange     m:NX Addon 0.11.x
    //--------------------
    // Client
    //--------------------
    // 0100: GetRelayService                            u:NX Addon 0.11.x
    // 0101: GetSystemDisplayService                    s:NX Addon 0.11.x
    // 0102: GetManagerDisplayService                   m:NX Addon 0.11.x
    // 0103: GetIndirectDisplayTransactionService       s:NX Addon 1.1.0
    // 0200: AllocateProcessHeapBlock                   m:NX Addon 4.1.0
    // 0201: FreeProcessHeapBlock                       m:NX Addon 4.1.0
    // 1000: ListDisplays                               u:NX Addon 0.11.x
    // 1010: OpenDisplay                                u:NX Addon 0.11.x
    // 1011: OpenDefaultDisplay                         u:NX Addon 0.11.x
    // 1020: CloseDisplay                               u:NX Addon 0.11.x
    // 1100: GetDisplayEnabled                          (reserved)
    // 1101: SetDisplayEnabled                          u:NX Addon 0.11.x (deprecated in 1.2.x)
    // 1102: GetDisplayResolution                       u:NX Addon 0.11.x (deprecated in 1.2.x)
    // 1103: SetDisplayResolution                       (reserved)
    // 1200: GetZOrderCountMin                          s:NX Addon 0.11.x
    // 1201: SetZOrderCountMin                          (reserved)
    // 1202: GetZOrderCountMax                          s:NX Addon 0.11.x
    // 1203: GetDisplayLogicalResolution                s:NX Addon 0.11.x
    // 2010: CreateManagedLayer                         m:NX Addon 0.11.x
    // 2011: DestroyManagedLayer                        m:NX Addon 0.11.x
    // 2020: OpenLayer                                  u:NX Addon 0.11.x
    // 2021: CloseLayer                                 u:NX Addon 0.11.x
    // 2030: CreateStrayLayer(u)                        u:NX Addon 0.11.x
    // 2031: DestroyStrayLayer(u)                       u:NX Addon 0.11.x
    // 2050: CreateIndirectLayer                        m:NX Addon 1.1.0
    // 2051: DestroyIndirectLayer                       m:NX Addon 1.1.0
    // 2052: CreateIndirectProducerEndPoint             m:NX Addon 1.1.0
    // 2053: DestroyIndirectProducerEndPoint            m:NX Addon 1.1.0
    // 2054: CreateIndirectConsumerEndPoint             m:NX Addon 1.1.0
    // 2055: DestroyIndirectConsumerEndPoint            m:NX Addon 1.1.0
    // 2100: GetLayerScalingMode                        u:NX Addon 0.11.x
    // 2101: SetLayerScalingMode                        u:NX Addon 0.11.x (deprecated in 5.2.x)
    // 2102: ConvertScalingMode                         u:NX Addon 5.2.0
    // 2200: GetLayerPosition                           s:NX Addon 0.11.x
    // 2201: SetLayerPosition                           s:NX Addon 0.11.x
    // 2202: GetLayerSize                               (reserved)
    // 2203: SetLayerSize                               s:NX Addon 0.11.x
    // 2204: GetLayerZ                                  s:NX Addon 0.11.x
    // 2205: SetLayerZ                                  s:NX Addon 0.11.x
    // 2206: GetLayerVisibility                         (reserved)
    // 2207: SetLayerVisibility                         s:NX Addon 0.11.x (deprecated in 1.2.x)
    // 2208: GetLayerAlpha                              (reserved)
    // 2209: SetLayerAlpha                              s:NX Addon 0.11.x
    // 2300: AcquireLayerTexturePresentingEvent         m:NX Addon 0.11.x
    // 2301: ReleaseLayerTexturePresentingEvent         m:NX Addon 0.11.x
    // 2302: GetDisplayHotplugEvent                     m:NX Addon 0.11.x
    // 2312: CreateStrayLayer(s)                        s:NX Addon 0.11.x
    // 2400: OpenIndirectLayer(s/producer)              s:NX Addon 1.1.0
    // 2401: CloseIndirectLayer(s/producer)             s:NX Addon 1.1.0
    // 2402: FlipIndirectLayer(s/producer)              s: NOTE: This will be removed
    // 2402: GetDisplayHotplugState                     m:NX Addon 0.11.x
    // 2450: GetIndirectLayerImageMap(u/consumer)       u:NX Addon 1.1.0
    // 2451: GetIndirectLayerImageCropMap(u/consumer)   u:NX Addon 1.1.0
    // 2460: GetIndirectLayerImageRequiredMemoryInfo    u:NX Addon 1.1.0
    // 3000: ListDisplayModes                           s:NX Addon 0.11.x
    // 3001: ListDisplayRgbRanges                       s:NX Addon 0.11.x
    // 3002: ListDisplayContentTypes                    s:NX Addon 0.11.x
    // 3200: GetDisplayMode                             s:NX Addon 0.11.x
    // 3201: SetDisplayMode                             s:NX Addon 0.11.x
    // 3202: GetDisplayUnderscan                        s:NX Addon 0.11.x
    // 3203: SetDisplayUnderscan                        s:NX Addon 0.11.x
    // 3204: GetDisplayContentType                      s:NX Addon 0.11.x
    // 3205: SetDisplayContentType                      s:NX Addon 0.11.x
    // 3206: GetDisplayRgbRange                         s:NX Addon 0.11.x
    // 3207: SetDisplayRgbRange                         s:NX Addon 0.11.x
    // 3208: GetDisplayCmuMode                          s:NX Addon 0.11.x
    // 3209: SetDisplayCmuMode                          s:NX Addon 0.11.x
    // 3210: GetDisplayContrastRatio                    s:NX Addon 0.11.x
    // 3211: SetDisplayContrastRatio                    s:NX Addon 0.11.x
    // 3213: SetDisplayHotplugState                     (reserved)
    // 3214: GetDisplayGamma                            s:NX Addon 0.11.x
    // 3215: SetDisplayGamma                            s:NX Addon 0.11.x
    // 3216: GetDisplayCmuLuma                          s:NX Addon 0.11.x
    // 3217: SetDisplayCmuLuma                          s:NX Addon 0.11.x
    // 4200: GetDisplayAlpha                            (reserved)
    // 4201: SetDisplayAlpha                            m:NX Addon 0.11.x
    // 4202: GetDisplayLayerStack                       (reserved)
    // 4203: SetDisplayLayerStack                       m:NX Addon 0.11.x
    // 4204: GetDisplayPowerState                       (reserved)
    // 4205: SetDisplayPowerState                       m:NX Addon 0.11.x
    // 5202: GetDisplayVsyncEvent                       u:NX Addon 0.11.x
    // 5203: GetDisplayVsyncEventForDebug               u:NX Addon 1.1.0
    // 6000: AddToLayerStack                            m:NX Addon 0.11.x
    // 6001: RemoveFromLayerStack                       m:NX Addon 0.11.x
    // 6002: SetLayerVisibility                         m:NX Addon 1.1.x
    // 6003: SetLayerConfig                             m:NX Addon 4.x.x
    // 6004: AttachLayerPresentationTracer              m:NX Addon 5.x.x
    // 6005: DetachLayerPresentationTracer              m:NX Addon 5.x.x
    // 6006: StartLayerPresentationRecording            m:NX Addon 5.x.x
    // 6007: StopLayerPresentationRecording             m:NX Addon 5.x.x
    // 6008: StartLayerPresentationFenceWait            m:NX Addon 5.x.x
    // 6009: StopLayerPresentationFenceWait             m:NX Addon 5.x.x
    // 6010: GetLayerPresentationAllFencesExpiredEvent  m:NX Addon 5.x.x
    // 7000: SetContentVisibility                       m:NX Addon 0.11.x
    // 8000: SetConductorLayer                          m:NX Addon 0.11.x
    // 8100: SetIndirectLayerFlipOffset                 m:NX Addon 1.1.0
    // 8200: CreateSharedBufferStaticStorage                    m:NX Addon 4.1.0
    // 8201: CreateSharedBufferTransferMemory                   m:NX Addon 4.1.0
    // 8202: DestroySharedBuffer                                m:NX Addon 4.1.0
    // 8203: BindSharedLowLevelLayerToManagedLayer              m:NX Addon 4.1.0
    // 8204: BindSharedLowLevelLayerToIndirectLayer             m:NX Addon 4.1.0
    // 8205: BindSharedLowLevelLayerToXxx                       m:(reserved)
    // 8206: BindSharedLowLevelLayerToXxx                       m:(reserved)
    // 8207: UnbindSharedLowLevelLayer                          m:NX Addon 4.1.0
    // 8208: ConnectSharedLowLevelLayerToSharedBuffer           m:NX Addon 4.1.0
    // 8209: DisconnectSharedLowLevelLayerFromToSharedBuffer    m:NX Addon 4.1.0
    // 8210: CreateSharedLayer                                  m:NX Addon 4.1.0
    // 8211: DestroySharedLayer                                 m:NX Addon 4.1.0
    // 8216: AttachSharedLayerToLowLevelLayer                   m:NX Addon 4.1.0
    // 8217: ForceDetachSharedLayerFromLowLevelLayer            m:NX Addon 4.1.0
    // 8218: StartDetachSharedLayerFromLowLevelLayer            m:NX Addon 4.1.0
    // 8219: FinishDetachSharedLayerFromLowLevelLayer           m:NX Addon 4.1.0
    // 8220: GetSharedLayerDetachReadyEvent                     m:NX Addon 4.1.0
    // 8221: GetSharedLowLevelLayerSynchronizedEvent            m:NX Addon 4.1.0
    // 8222: SynchronizeSharedLowLevelLayer                     m:(reserved)
    // 8223: RegisterSharedBufferImporterAruid                  m:NX Addon 4.1.0
    // 8224: UnregisterSharedBufferImporterAruid                m:NX Addon 4.1.0
    // 8225: GetSharedBufferMemoryHandleId                      s:NX Addon 4.1.0
    // 8226: RepatriateSharedBuffer(?)                          s:(reserved)
    // 8227: CreateSharedBufferProcessHeap                      m:NX Addon 4.1.0
    // 8228: GetSharedLayerLayerStack                           m:NX Addon 4.1.0
    // 8229: SetSharedLayerLayerStack                           m:NX Addon 4.1.0
    // 8250: OpenSharedLayer                                    s:NX Addon 4.1.0
    // 8251: CloseSharedLayer                                   s:NX Addon 4.1.0
    // 8252: ConnectSharedLayer                                 s:NX Addon 4.1.0
    // 8253: DisconnectSharedLayer                              s:NX Addon 4.1.0
    // 8254: AcquireSharedFrameBuffer                           s:NX Addon 4.1.0
    // 8255: PresentSharedFrameBuffer                           s:NX Addon 4.1.0
    // 8256: GetSharedFrameBufferAcquirableEvent                s:NX Addon 4.1.0
    // 8257: FillSharedFrameBufferColor                         s:NX Addon 4.1.0
    // 8258: CancelSharedFrameBuffer                           s:NX Addon 5.0.0
    // 8290: AcquireSharedFrameBufferFromManagedLayer           m:(reserved)
    // 8291: PresentDetachedSharedFrameBufferToManagedLayer     m:NX Addon 4.1.0
    // 8292: FillDetachedSharedFrameBufferColor                 m:NX Addon 4.1.0
    // 8293: GetDetachedSharedFrameBufferImage                  m:NX Addon 4.1.0
    // 8294: SetDetachedSharedFrameBufferImage                  m:NX Addon 4.1.0
    // 8295: CopyDetachedSharedFrameBufferImage                 m:NX Addon 4.1.0
    // 8296: SetDetachedSharedFrameBufferSubImage               m:NX Addon 4.1.0
    // 8297: GetSharedFrameBufferContentParameter               m:NX Addon 4.1.0
    // 8298: ExpandStartUpLogoOnSharedFrameBuffer               m:NX Addon 5.1.0


//================================
// Application
//================================
    public interface IApplicationDisplayService : IServiceObject
    {
        [MethodId(100)]
        Result GetRelayService(Out<nns.hosbinder.IHOSBinderDriver> outRelayService);

        [MethodId(101)]
        Result GetSystemDisplayService(Out<ISystemDisplayService> outSystemService);

        [MethodId(102)]
        Result GetManagerDisplayService(Out<IManagerDisplayService> outManagerService);

        [MethodId(103)]
        Result GetIndirectDisplayTransactionService(Out<nns.hosbinder.IHOSBinderDriver> outService);

    //---------
    // Display
    //---------

    // List

        [MethodId(1000)]
        Result ListDisplays(
            Out<int64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutArray<vi.DisplayInfo> outInfo
            );

    // Open/Close

        [MethodId(1010)]
        Result OpenDisplay(Out<vi.DisplayId> outDisplayId, vi.DisplayName name);

        [MethodId(1011)]
        Result OpenDefaultDisplay(Out<vi.DisplayId> outDisplayId);

        [MethodId(1020)]
        Result CloseDisplay(vi.DisplayId displayId);

    // Getter/Setter

        // [MethodId(1100)]
        // Result GetDisplayEnabled(...);

        [MethodId(1101)]
        Result SetDisplayEnabled(vi.DisplayId displayId, bool isEnabled);

        [MethodId(1102)]
        Result GetDisplayResolution(Out<int64_t> outWidth, Out<int64_t> outHeight, vi.DisplayId displayId);

        // [MethodId(1103)]
        // Result SetDisplayResolution(...);

        //---------
        // Layer
        //---------

        // Create/Destroy

        [MethodId(2020)]
        Result OpenLayer(
            Out<int64_t> outNativeWindowDataSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutBuffer outNativeWindowData,
            vi.LayerId  layerId,
            vi.DisplayName displayName,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(2021)]
        Result CloseLayer(
            vi.LayerId layerId
            );

        [MethodId(2030)]
        Result CreateStrayLayer(
            Out<vi.LayerId> outLayerId,
            Out<int64_t> outNativeWindowDataSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutBuffer outNativeWindowData,
            vi.DisplayId displayId,
            vi.LayerSettingsType settings
        );

        [MethodId(2031)]
        Result DestroyStrayLayer(
            vi.LayerId layerId
            );

    // Getter/Setter

        // [MethodId(2100)]
        // Result GetLayerScalingMode(...);

        [MethodId(2101)]
        Result SetLayerScalingMode(vi.LayerId layerId, vi.ScalingModeType mode);

        [MethodId(2102)]
        Result ConvertScalingMode(Out<int64_t> outMode, vi.ScalingModeType viMode);

        //---------
        // IndirectLayer
        //---------
        [MethodId(2450)]
        Result GetIndirectLayerImageMap(
            Out<int64_t> outSize,
            Out<int64_t> outStride,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.NonSecureMapTransfer()]
            OutBuffer outBuffer,
            int64_t width,
            int64_t height,
            vi.IndirectConsumerHandleType consumerHandle,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(2451)]
        Result GetIndirectLayerImageCropMap(
            Out<int64_t> outSize,
            Out<int64_t> outStride,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.NonSecureMapTransfer()]
            OutBuffer outBuffer,
            int64_t width,
            int64_t height,
            float sourceRectX,
            float sourceRectY,
            float sourceRectWidth,
            float sourceRectHeight,
            vi.IndirectConsumerHandleType consumerHandle,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(2460)]
        Result GetIndirectLayerImageRequiredMemoryInfo(
            Out<int64_t> outSize,
            Out<int64_t> outAlignment,
            int64_t width,
            int64_t height
            );

        // Events

        [MethodId(5202)]
        Result GetDisplayVsyncEvent(Out<nn.sf.NativeHandle> outHandle, vi.DisplayId displayId);

        [MethodId(5203)]
        Result GetDisplayVsyncEventForDebug(Out<nn.sf.NativeHandle> outHandle, vi.DisplayId displayId);

    }

//================================
// System
//================================
    public interface ISystemDisplayService : IServiceObject
    {
    //---------
    // Display
    //---------

    // Getter/Setter

        [MethodId(1200)]
        Result GetZOrderCountMin(Out<int64_t> outValue, vi.DisplayId displayId);

        // [MethodId(1201)]
        // Result SetZOrderCountMin(...);

        [MethodId(1202)]
        Result GetZOrderCountMax(Out<int64_t> outValue, vi.DisplayId displayId);

        // [MethodId(1203)]
        // Result SetZOrderCountMax(...);

        [MethodId(1203)]
        Result GetDisplayLogicalResolution(Out<int32_t> outWidth, Out<int32_t> outHeight, vi.DisplayId displayId);

        [MethodId(1204)]
        Result SetDisplayMagnification(vi.DisplayId displayId, int x, int y, int width, int height);

        //---------
        // Layer
        //---------
        // Getter/Setter

        // [MethodId(2200)
        // Result GetLayerPosition(...);

        [MethodId(2201)]
        Result SetLayerPosition(vi.LayerId layerId, float x, float y);

        // [MethodId(2202)]
        // Result GetLayerSize(...);

        [MethodId(2203)]
        Result SetLayerSize(vi.LayerId layerId, int64_t width, int64_t height);

        [MethodId(2204)]
        Result GetLayerZ(Out<int64_t> outZ, vi.LayerId layerId);

        [MethodId(2205)]
        Result SetLayerZ(vi.LayerId layerId, int64_t z);

        // [MethodId(2206)]
        // Result GetLayerVisibility(...);

        [MethodId(2207)]
        Result SetLayerVisibility(vi.LayerId layerId, bool isVisible);

        // [MethodId(2208)]
        // Result GetLayerAlpha(...);

        [MethodId(2209)]
        Result SetLayerAlpha(vi.LayerId layerId, float alpha);

        [MethodId(2312)]
        Result CreateStrayLayer(
            Out<vi.LayerId> outLayerId,
            Out<int64_t> outNativeWindowDataSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutBuffer outNativeWindowData,
            vi.DisplayId displayId,
            vi.LayerSettingsType settings
        );

        //---------
        // IndirectLayer
        //---------

        [MethodId(2400)]
        Result OpenIndirectLayer(
            Out<int64_t> outNativeWindowDataSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutBuffer outNativeWindowData,
            vi.IndirectProducerHandleType producerHandle,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(2401)]
        Result CloseIndirectLayer(
            vi.IndirectProducerHandleType producerHandle
            );

        [MethodId(2402)]
        Result FlipIndirectLayer(
            vi.IndirectProducerHandleType producerHandle
            );

        //-------
        // SharedLayer
        //-------

        [MethodId(8225)]
        Result GetSharedBufferMemoryHandleId(
            Out<vi.native.NativeMemoryHandleId> outMemoryHandleId,
            Out<uint64_t> outMemorySize,
            Out<vi.fbshare.SharedMemoryPoolLayout> outLayout,
            vi.fbshare.SharedBufferHandle hBuffer,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(8250)]
        Result OpenSharedLayer(
            vi.fbshare.SharedLayerHandle hLayer,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(8251)]
        Result CloseSharedLayer(
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8252)]
        Result ConnectSharedLayer(
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8253)]
        Result DisconnectSharedLayer(
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8254)]
        Result AcquireSharedFrameBuffer(
            Out<int64_t> outIndex,
            Out<vi.native.NativeSync> outSync,
            Out<vi.fbshare.SharedLayerTextureIndexList> outIndexList,
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8255)]
        Result PresentSharedFrameBuffer(
            vi.fbshare.SharedLayerHandle hLayer,
            int64_t index,
            vi.native.NativeSync sync,
            vi.CropRegion crop,
            vi.ImageTransformType transform,
            int32_t presentInterval
            );

        [MethodId(8256)]
        Result GetSharedFrameBufferAcquirableEvent(
            Out<NativeHandle> outHandle,
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8257)]
        Result FillSharedFrameBufferColor(
            vi.fbshare.SharedLayerHandle hLayer,
            int64_t index,
            int32_t r,
            int32_t g,
            int32_t b,
            int32_t a
            );

        [MethodId(8258)]
        Result CancelSharedFrameBuffer(
            vi.fbshare.SharedLayerHandle hLayer,
            int64_t index
            );

        //---------
    // DisplayMode
    //---------

    // List

        [MethodId(3000)]
        Result ListDisplayModes(
            Out<int64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutArray<vi.DisplayModeInfo> outModes,
            vi.DisplayId displayId
            );

        [MethodId(3001)]
        Result ListDisplayRgbRanges(
            Out<int64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutArray<vi.RgbRangeType> outRanges,
            vi.DisplayId displayId
            );

        [MethodId(3002)]
        Result ListDisplayContentTypes(
            Out<int64_t> outCount,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            OutArray<vi.ContentTypeType> outTypes,
            vi.DisplayId dispayId
            );

    // Getter/Setter

        [MethodId(3200)]
        Result GetDisplayMode(Out<vi.DisplayModeInfo> outMode, vi.DisplayId displayId);

        [MethodId(3201)]
        Result SetDisplayMode(vi.DisplayId displayId, vi.DisplayModeInfo mode);

        [MethodId(3202)]
        Result GetDisplayUnderscan(Out<int64_t> outUnderscan, vi.DisplayId displayId);

        [MethodId(3203)]
        Result SetDisplayUnderscan(vi.DisplayId displayId, int64_t underscan);

        [MethodId(3204)]
        Result GetDisplayContentType(Out<vi.ContentTypeType> outType, vi.DisplayId displayId);

        [MethodId(3205)]
        Result SetDisplayContentType(vi.DisplayId displayId, vi.ContentTypeType type);

        [MethodId(3206)]
        Result GetDisplayRgbRange(Out<vi.RgbRangeType> outRange, vi.DisplayId displayId);

        [MethodId(3207)]
        Result SetDisplayRgbRange(vi.DisplayId displayId, vi.RgbRangeType range);

        [MethodId(3208)]
        Result GetDisplayCmuMode(Out<vi.CmuModeType> outMode, vi.DisplayId displayId);

        [MethodId(3209)]
        Result SetDisplayCmuMode(vi.DisplayId displayId, vi.CmuModeType mode);

        [MethodId(3210)]
        Result GetDisplayContrastRatio(Out<float> outRatio, vi.DisplayId displayId);

        [MethodId(3211)]
        Result SetDisplayContrastRatio(vi.DisplayId displayId, float ratio);

        // [MethodId(3213)]
        // Result SetDisplayHotplugState(...);

        [MethodId(3214)]
        Result GetDisplayGamma(Out<float> outGamma, vi.DisplayId displayId);

        [MethodId(3215)]
        Result SetDisplayGamma(vi.DisplayId displayId, float gamma);

        [MethodId(3216)]
        Result GetDisplayCmuLuma(Out<float> outValue, vi.DisplayId displayId);

        [MethodId(3217)]
        Result SetDisplayCmuLuma(vi.DisplayId displayId, float value);


    }

//================================
// Manager
//================================
    public interface IManagerDisplayService : IServiceObject
    {
        //---------
        // Heap
        //---------
        [MethodId(200)]
        Result AllocateProcessHeapBlock(Out<uint64_t> outBlockId, uint64_t size);

        [MethodId(201)]
        Result FreeProcessHeapBlock(uint64_t blockId);

        //---------
        // Display
        //---------

        // Getter/Setter

        [MethodId(1102)]
        Result GetDisplayResolution(Out<int64_t> outWidth, Out<int64_t> outHeight, vi.DisplayId displayId);

        [MethodId(2010)]
        Result CreateManagedLayer(
            Out<vi.LayerId> outLayerId,
            vi.DisplayId displayId,
            vi.LayerSettingsType settings,
            applet.AppletResourceUserId userAruid
            );

        [MethodId(2011)]
        Result DestroyManagedLayer(
            vi.LayerId layerId
            );

        //---------
        // IndirectLayer
        //---------
        [MethodId(2050)]
        Result CreateIndirectLayer(
            Out<vi.IndirectLayerHandleType> outLayerHandle
            );

        [MethodId(2051)]
        Result DestroyIndirectLayer(
            vi.IndirectLayerHandleType layerHandle
            );

        [MethodId(2052)]
        Result CreateIndirectProducerEndPoint(
            Out<vi.IndirectProducerHandleType> outProducerEndPointHandle,
            vi.IndirectLayerHandleType layerHandle,
            applet.AppletResourceUserId aruid
            );

        [MethodId(2053)]
        Result DestroyIndirectProducerEndPoint(
            vi.IndirectLayerHandleType layerHandle
            );

        [MethodId(2054)]
        Result CreateIndirectConsumerEndPoint(
            Out<vi.IndirectConsumerHandleType> outConsumerEndPointHandle,
            vi.IndirectLayerHandleType layerHandle,
            applet.AppletResourceUserId aruid
            );

        [MethodId(2055)]
        Result DestroyIndirectConsumerEndPoint(
            vi.IndirectLayerHandleType layerHandle
            );

        //---------
        // FrameBufferSharing
        //---------
        [MethodId(8200)]
        Result CreateSharedBufferStaticStorage(
            Out<vi.fbshare.SharedBufferHandle> outHandle,
            uint64_t storageKey,
            vi.fbshare.SharedMemoryPoolLayout layout
            );

        [MethodId(8201)]
        Result CreateSharedBufferTransferMemory(
            Out<vi.fbshare.SharedBufferHandle> outHandle,
            NativeHandle transferMemoryHandle,
            uint64_t transferMemorySize,
            vi.fbshare.SharedMemoryPoolLayout layout
            );

        [MethodId(8202)]
        Result DestroySharedBuffer(
            vi.fbshare.SharedBufferHandle handle
            );

        [MethodId(8203)]
        Result BindSharedLowLevelLayerToManagedLayer(
            vi.LayerId layerId,
            vi.DisplayName displayName,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(8204)]
        Result BindSharedLowLevelLayerToIndirectLayer(
            vi.IndirectProducerHandleType handle,
            applet.CheckedAppletResourceUserId aruid
            );

        [MethodId(8207)]
        Result UnbindSharedLowLevelLayer(
            vi.LayerId layerId
            );

        [MethodId(8208)]
        Result ConnectSharedLowLevelLayerToSharedBuffer(
            vi.LayerId layerId,
            vi.fbshare.SharedBufferHandle hSharedBuffer
            );

        [MethodId(8209)]
        Result DisconnectSharedLowLevelLayerFromSharedBuffer(
            vi.LayerId layerId
            );

        [MethodId(8210)]
        Result CreateSharedLayer(
            Out<vi.fbshare.SharedLayerHandle> outLayerHandle,
            applet.AppletResourceUserId userAruid
            );

        [MethodId(8211)]
        Result DestroySharedLayer(
            vi.fbshare.SharedLayerHandle hLayer
            );

        [MethodId(8216)]
        Result AttachSharedLayerToLowLevelLayer(
            vi.fbshare.SharedLayerHandle hSharedLayer,
            vi.LayerId layerId,
            vi.fbshare.SharedLayerTextureIndexList frameBufferIndexList
            );

        [MethodId(8217)]
        Result ForceDetachSharedLayerFromLowLevelLayer(
            vi.fbshare.SharedLayerHandle hSharedLayer
            );

        [MethodId(8218)]
        Result StartDetachSharedLayerFromLowLevelLayer(
            vi.fbshare.SharedLayerHandle hSharedLayer
            );

        [MethodId(8219)]
        Result FinishDetachSharedLayerFromLowLevelLayer(
            vi.fbshare.SharedLayerHandle hSharedLayer
            );

        [MethodId(8220)]
        Result GetSharedLayerDetachReadyEvent(
            Out<nn.sf.NativeHandle> outHandle,
            vi.fbshare.SharedLayerHandle hSharedLayer
            );

        [MethodId(8221)]
        Result GetSharedLowLevelLayerSynchronizedEvent(
            Out<nn.sf.NativeHandle> outHandle,
            vi.LayerId layerId
            );

        [MethodId(8222)]
        Result CheckSharedLowLevelLayerSynchronized(
            Out<int64_t> outDisplayedIndex,
            vi.LayerId layerId
            );

        [MethodId(8223)]
        Result RegisterSharedBufferImporterAruid(
            vi.fbshare.SharedBufferHandle hBuffer,
            applet.AppletResourceUserId importerAruid
            );

        [MethodId(8224)]
        Result UnregisterSharedBufferImporterAruid(
            vi.fbshare.SharedBufferHandle hBuffer,
            applet.AppletResourceUserId importerAruid
            );

        [MethodId(8227)]
        Result CreateSharedBufferProcessHeap(
            Out<vi.fbshare.SharedBufferHandle> outHandle,
            uint64_t blockId,
            vi.fbshare.SharedMemoryPoolLayout layout
            );

        [MethodId(8228)]
        Result GetSharedLayerLayerStacks(
            Out<vi.LayerStackFlagType> outStacks,
            vi.fbshare.SharedLayerHandle hSharedLayer
            );

        [MethodId(8229)]
        Result SetSharedLayerLayerStacks(
            vi.fbshare.SharedLayerHandle hSharedLayer,
            vi.LayerStackFlagType stacks
            );

        //[MethodId(8290)]
        //Result AcquireSharedFrameBufferFromManagedLayer(
        //    vi.fbshare.SharedBufferHandle hSharedBuffer,
        //    vi.LayerId layerId,
        //    int64_t index
        //    );

        [MethodId(8291)]
        Result PresentDetachedSharedFrameBufferToLowLevelLayer(
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            vi.LayerId layerId,
            int64_t index
            );

        [MethodId(8292)]
        Result FillDetachedSharedFrameBufferColor(
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t index,
            uint32_t color,
            vi.fbshare.SharedTextureOption option
            );

        [MethodId(8293)]
        Result GetDetachedSharedFrameBufferImage(
            Out<uint64_t> outDataSize,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.OutBuffer data,
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t index
            );

        [MethodId(8294)]
        Result SetDetachedSharedFrameBufferImage(
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t index,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            nn.sf.InBuffer data,
            vi.fbshare.SharedTextureOption dstOption,
            vi.ImageTransformType srcTransform
            );

        [MethodId(8295)]
        Result CopyDetachedSharedFrameBufferImage(
            vi.fbshare.SharedBufferHandle hDstSharedBuffer,
            int64_t dstIndex,
            vi.fbshare.SharedBufferHandle hSrcSharedBuffer,
            int64_t srcIndex,
            vi.fbshare.SharedTextureOption dstOption,
            vi.LayerStackFlagType maskStacks,
            vi.LayerStackFlagType nullStacks
            );

        [MethodId(8296)]
        Result SetDetachedSharedFrameBufferSubImage(
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t index,
            int32_t x,
            int32_t y,
            int32_t w,
            int32_t h,
            uint32_t bgColor,
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            [Nintendo.ServiceFramework.Hipc.NonSecureMapTransfer]
            nn.sf.InBuffer data,
            vi.fbshare.SharedTextureOption dstOption,
            vi.ImageTransformType srcTransform
            );

        [MethodId(8297)]
        Result GetSharedFrameBufferContentParameter(
            Out<vi.LayerStackFlagType> outLayerStacks,
            Out<vi.CropRegion> outCropRegion,
            Out<int32_t> outScalingMode,
            Out<uint32_t> outTransform,
            Out<int32_t> outPresentInterval,
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t index
            );

        [MethodId(8298)]
        Result ExpandStartupLogoOnSharedFrameBuffer(
            vi.fbshare.SharedBufferHandle hSharedBuffer,
            int64_t dstIndex,
            vi.fbshare.SharedTextureOption option
            );


        //---------
        // DisplayEvents
        //---------
        [MethodId(2300)]
        Result AcquireLayerTexturePresentingEvent(Out<nn.sf.NativeHandle> outHandle, vi.LayerId layerId);

        [MethodId(2301)]
        Result ReleaseLayerTexturePresentingEvent(vi.LayerId layerId);

        [MethodId(2302)]
        Result GetDisplayHotplugEvent(Out<nn.sf.NativeHandle> outHandle, vi.DisplayId displayId);

        [MethodId(2303)]
        Result GetDisplayModeChangedEvent(Out<nn.sf.NativeHandle> outHandle, vi.DisplayId displayId);

        [MethodId(2402)]
        Result GetDisplayHotplugState(Out<vi.HotplugStateType> outState, vi.DisplayId displayId);

        [MethodId(2501)]
        Result GetCompositorErrorInfo(
            [Nintendo.ServiceFramework.Hipc.BufferTransferMode(Nintendo.ServiceFramework.Hipc.BufferTransferMode.MapAlias)]
            Out<vi.CompositorError> outErrorInfo,
            Out<int32_t> outLength,
            int64_t errorId,
            vi.DisplayId displayId
            );

        [MethodId(2601)]
        Result GetDisplayErrorEvent(Out<nn.sf.NativeHandle> outHandle, vi.DisplayId displayId);

        //---------
        // DisplayConfig
        //---------

        //[MethodId(4200)]
        //Result GetDisplayAlpha();

        [MethodId(4201)]
        Result SetDisplayAlpha(vi.DisplayId displayId, float alpha);

        //[MethodId(4202)]
        //Result GetDisplayLayerStack();

        [MethodId(4203)]
        Result SetDisplayLayerStack(vi.DisplayId displayId, vi.LayerStackType id);

        //[MethodId(4204)]
        //Result GetDisplayPowerState();

        [MethodId(4205)]
        Result SetDisplayPowerState(vi.DisplayId displayId, vi.PowerStateType state);

        [MethodId(4206)]
        Result SetDefaultDisplay(vi.DisplayId id);

        //---------
        // LayerConfig
        //---------

        [MethodId(6000)]
        Result AddToLayerStack(vi.LayerId layerId, vi.LayerStackType stackId);

        [MethodId(6001)]
        Result RemoveFromLayerStack(vi.LayerId layerId, vi.LayerStackType stackId);

        [MethodId(6002)]
        Result SetLayerVisibility(vi.LayerId layerId, bool isVisible);

        [MethodId(6003)]
        Result SetLayerConfig(vi.LayerId layerId, vi.LayerConfig config);

        [MethodId(6004)]
        Result AttachLayerPresentationTracer(vi.LayerId layerId);

        [MethodId(6005)]
        Result DetachLayerPresentationTracer(vi.LayerId layerId);

        [MethodId(6006)]
        Result StartLayerPresentationRecording(vi.LayerId layerId);

        [MethodId(6007)]
        Result StopLayerPresentationRecording(vi.LayerId layerId);

        [MethodId(6008)]
        Result StartLayerPresentationFenceWait(vi.LayerId layerId);

        [MethodId(6009)]
        Result StopLayerPresentationFenceWait(vi.LayerId layerId);

        [MethodId(6010)]
        Result GetLayerPresentationAllFencesExpiredEvent(Out<nn.sf.NativeHandle> outHandle, vi.LayerId layerId);

        [MethodId(7000)]
        void SetContentVisibility(bool isVisible);

        [MethodId(8000)]
        Result SetConductorLayer(vi.LayerId layerId, bool isConductor);

        [MethodId(8100)]
        Result SetIndirectProducerFlipOffset(vi.IndirectLayerHandleType layerHandle, vi.IndirectProducerHandleType producerHandle, TimeSpan offset);

    }

}
