﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdio>
#include <cstring>
#include "../visrv_Log.h"
#include "visrv_PhysicalDisplay.h"
#include "detail/visrv_Read.h"

namespace
{
    const int InvalidId = -1;
}

namespace nn { namespace visrv { namespace settings {

    PhysicalDisplay::PhysicalDisplay() NN_NOEXCEPT
        : name{ 0 }
        , edidDisplayName{ 0 }
        , dc(InvalidId)
    {
    }

    bool PhysicalDisplay::Read(int id) NN_NOEXCEPT
    {
        char keyBuffer[128];

        std::snprintf(keyBuffer, sizeof(keyBuffer), "physical_display_%d_name", id);
        if( detail::ReadArray(this->name, keyBuffer) == 0 )
        {
            NN_VISRV_LOG_WARN("Physical display (id = %d) is missing a name.  Skipping entry.\n", id);
            Reset();
            return false;
        }

        std::snprintf(keyBuffer, sizeof(keyBuffer), "physical_display_%d_dc", id);
        if( detail::ReadItem(&this->dc, keyBuffer) != sizeof(this->dc) )
        {
            NN_VISRV_LOG_WARN("Physical display (id = %d) is missing a DC.  Skipping entry.\n", id);
            Reset();
            return false;
        }

        if( std::strlen(this->name) == 0 || this->dc < 0 )
        {
            Reset();
            return false;
        }

        std::snprintf(keyBuffer, sizeof(keyBuffer), "physical_display_%d_edid_display_name", id);
        if( detail::ReadArray(this->edidDisplayName, keyBuffer) == 0 )
        {
            NN_VISRV_LOG_WARN("Physical display (id = %d) is missing an EDID display name.  Defaulting to no EDID display.\n", id);
            std::memset(this->edidDisplayName, 0, sizeof(this->edidDisplayName));
        }

        return true;
    }

    void PhysicalDisplay::Reset() NN_NOEXCEPT
    {
        std::memset(this->name, 0, sizeof(this->name));
        std::memset(this->edidDisplayName, 0, sizeof(this->edidDisplayName));
        this->dc = InvalidId;
    }

}}}
