﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_IndirectDisplayTransactionServiceImpl.h"

#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include "../visrv_Config.h"
#include "../visrv_Log.h"


namespace nn{ namespace visrv{ namespace service{

    IndirectDisplayTransactionServiceImpl::IndirectDisplayTransactionServiceImpl(client::ClientObjectSmartHolder* pClientHolder) NN_NOEXCEPT
        : m_ClientHolder(pClientHolder)
    {
        NN_VISRV_LOG_LIFETIME("IndirectDisplayTransactionServiceImpl ctor\n");
    }

    IndirectDisplayTransactionServiceImpl::~IndirectDisplayTransactionServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("IndirectDisplayTransactionServiceImpl dtor\n");
    }

    void IndirectDisplayTransactionServiceImpl::TransactParcel(
        std::int32_t handle,
        std::uint32_t code,
        const nn::sf::InBuffer& requestBuffer,
        const nn::sf::OutBuffer& replyBuffer,
        std::uint32_t flags
        ) NN_NOEXCEPT
    {
        m_ClientHolder->IndirectDisplayTransactParcel(
            handle,
            code,
            requestBuffer.GetPointerUnsafe(),
            requestBuffer.GetSize(),
            replyBuffer.GetPointerUnsafe(),
            replyBuffer.GetSize(),
            flags
        );
    }

    void IndirectDisplayTransactionServiceImpl::TransactParcelAuto(
        std::int32_t handle,
        std::uint32_t code,
        const nn::sf::InBuffer& requestBuffer,
        const nn::sf::OutBuffer& replyBuffer,
        std::uint32_t flags
        ) NN_NOEXCEPT
    {
        m_ClientHolder->IndirectDisplayTransactParcel(
            handle,
            code,
            requestBuffer.GetPointerUnsafe(),
            requestBuffer.GetSize(),
            replyBuffer.GetPointerUnsafe(),
            replyBuffer.GetSize(),
            flags
        );
    }

    void IndirectDisplayTransactionServiceImpl::AdjustRefcount(
        std::int32_t handle,
        std::int32_t diff,
        std::int32_t isStrong
        ) NN_NOEXCEPT
    {
        m_ClientHolder->IndirectDisplayAdjustRefcount(handle, diff, isStrong);
    }

    void IndirectDisplayTransactionServiceImpl::GetNativeHandle(
        std::int32_t handle,
        std::uint32_t code,
        nn::sf::Out<nn::sf::NativeHandle> result
        ) NN_NOEXCEPT
    {
        m_ClientHolder->IndirectDisplayGetNativeHandle(handle, code, result);
    }

}}}

