﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_IndirectDisplayTransactionServiceFactory.h"

#include <nn/sf/sf_ObjectFactory.h>
#include "visrv_IndirectDisplayTransactionServiceImpl.h"

namespace nn{ namespace visrv{ namespace service{

    nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver> IndirectDisplayTransactionServiceFactory::Create(
        client::ClientObjectSmartHolder* pHolder
        ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(pHolder);
        NN_SDK_REQUIRES_NOT_NULL(pHolder->Get());
        NN_SDK_REQUIRES(pHolder->Get()->IsAlive());
        return nn::sf::CreateSharedObjectEmplaced<nns::hosbinder::IHOSBinderDriver, IndirectDisplayTransactionServiceImpl>(pHolder);
    }

}}}
