﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_DriverConnection.h"

#include "../visrv_Config.h"

// HIPC
#include <nn/sf/sf_ShimLibraryUtility.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/vi/sf/hosbinder_IHOSBinderDriver.sfdl.h>

// android driver
#include <private/binder/hosbinder_Driver.h>
#include <binder/HOSServiceManager.h>
#include <utils/String8.h>

namespace nn{ namespace visrv{ namespace service{

    namespace {
        typedef nns::hosbinder::IHOSBinderDriver IServiceType;

        nn::sf::ShimLibraryObjectHolder<IServiceType> g_ServiceHolder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
    }


    void InitializeDriverConnection() NN_NOEXCEPT
    {
        static const size_t ObjectCountMax = 10;
        static nn::sf::SimpleAllInOneHipcClientManager<ObjectCountMax> s_AioManager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;

        NN_ABORT_UNLESS_RESULT_SUCCESS(
            s_AioManager.InitializeShimLibraryHolder(&g_ServiceHolder, NN_VISRV_RELAY_PORTNAME)
        );

        // register driver to libandroid
        auto pServiceManager = android::defaultHOSServiceManager();
        android::String8 name(NN_VISRV_RELAY_PORTNAME);
        pServiceManager->addServiceProxy(name, g_ServiceHolder.GetObject());
    }

    nn::sf::SharedPointer<nns::hosbinder::IHOSBinderDriver> GetDriverConnection() NN_NOEXCEPT
    {
        return g_ServiceHolder.GetObject();
    }


}}}
