﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_SerializeNativeWindow.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>
#include <nvnflinger_service.h>
#include "../visrv_Log.h"
#include "visrv_ParcelIo.h"

namespace nn{ namespace visrv{ namespace native{

    namespace {
        const nn::vi::ProxyName DriverProxyName = { NN_VISRV_RELAY_PORTNAME };

        struct ReplaceProxyNameArgument
        {
            nn::vi::ProxyName clientProxyName;
        };

        void ReplaceProxyName(flat_binder_object* pObject, void* userPtr) NN_NOEXCEPT
        {
            auto pArg = reinterpret_cast<ReplaceProxyNameArgument*>(userPtr);
            if(std::memcmp(pObject->service_name, &DriverProxyName, sizeof(nn::vi::ProxyName)) == 0)
            {
                std::memcpy(&pObject->service_name[0], &pArg->clientProxyName.value[0], sizeof(nn::vi::ProxyName));
                //NN_VISRV_LOG("binder name replaced %s -> %s\n", &DriverProxyName, &pArg->clientProxyName);
            }
        }
    }

    nn::Result SerializeNativeWindow(
        int32_t* pOutDriverHandle,
        size_t* pOutDataSize,
        void* buffer,
        size_t bufferSize,
        master::Layer* pLayer,
        bool isProxyNameExchangeEnabled,
        const nn::vi::ProxyName& clientProxyName
        ) NN_NOEXCEPT
    {
        size_t written = 0;
        {
            android::Parcel parcel;
            parcel.writeStrongBinder(pLayer->m_GraphicBufferProducer->asBinder());
            NN_RESULT_THROW_UNLESS(
                parcel.errorCheck() == 0,
                nn::vi::ResultOperationFailed()
            );
            ParcelIo::WriteParcel(&written, buffer, bufferSize, &parcel);
            NN_RESULT_THROW_UNLESS(
                written > 0,
                nn::vi::ResultOperationFailed()
            );
        }

        // read back driver handle
        {
            android::Parcel p;
            size_t dataPositon;
            ParcelIo::OpenParcel(&p, &dataPositon, buffer, written);
            auto pObj = p.readObject(false);
            NN_SDK_ASSERT_NOT_NULL(pObj);
            *pOutDriverHandle = pObj->handle;
            ParcelIo::CloseParcel(&p);
        }

        // replace proxy name in buffer
        if(isProxyNameExchangeEnabled)
        {
            android::Parcel p;
            size_t dataPosition;
            ParcelIo::OpenParcel(&p, &dataPosition, buffer, written);
            ReplaceProxyNameArgument arg;
            arg.clientProxyName = clientProxyName;
            p.foreachObject(ReplaceProxyName, &arg);
            ParcelIo::CloseParcel(&p);
        }
        *pOutDataSize = written;
        NN_RESULT_SUCCESS;
    }

}}}
