﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../visrv_NativeType.h"
#include <ui/Fence.h>

namespace nn{ namespace visrv{ namespace native{ namespace detail{

    class TransactionIGraphicBufferProducer
    {
    public:
        struct Rect
        {
        public:
            void Read(android::Parcel& parcel) NN_NOEXCEPT;
            void Write(android::Parcel& parcel) NN_NOEXCEPT;
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t left;
            int32_t top;
            int32_t right;
            int32_t bottom;
        };

        // Non-POD
        struct QueueBufferInput
        {
        public:
            void ReadFrom(android::Parcel& parcel) NN_NOEXCEPT;
            void WriteTo(android::Parcel& parcel) const NN_NOEXCEPT;
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int64_t timestamp;
            int32_t isAutoTimestamp;
            Rect crop;
            int32_t scalingMode;
            uint32_t transform;
            uint32_t flags;
            int32_t async;
            int32_t interval;
            android::sp<android::Fence> fence;
        };

        // POD
        struct QueueBufferOutput
        {
        public:
            void ReadFrom(android::Parcel& parcel) NN_NOEXCEPT;
            void WriteTo(android::Parcel& parcel) const NN_NOEXCEPT;
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            uint32_t width;
            uint32_t height;
            uint32_t transformHint;
            uint32_t numPendingBuffers;
        };

    public:
        struct RequestBufferRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t bufferIndex;
        };

        struct RequestBufferReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            android::sp<android::GraphicBuffer> buf;
            int32_t result;
        };

        struct SetBufferCountRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t count;
        };

        struct SetBufferCountReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t result;
        };

        struct ConnectRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t hasListener;     // Always 0 in HOS
            int32_t api;             // Almost always CPU
            int32_t controlledByApp; // Always 0 in HOS
        };

        struct ConnectReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            QueueBufferOutput output;
            int32_t result;
        };

        struct DisconnectRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t api;
        };

        struct DisconnectReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t result;
        };

        struct DequeueBufferRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t async;
            int32_t w;
            int32_t h;
            int32_t format;
            int32_t usage;
        };

        struct DequeueBufferReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t buf;
            android::sp<android::Fence> fence;
            int32_t result;
        };

        struct QueueBufferRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int buf;
            QueueBufferInput input;
        };

        struct QueueBufferReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            QueueBufferOutput output;
            int32_t result;
        };

        struct SetPreallocatedBufferRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t slot;
            android::sp<android::GraphicBuffer> buffer;
        };

        struct SetPreallocatedBufferReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t result;
        };

        struct QueryRequest
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t what;
        };

        struct QueryReply
        {
        public:
            size_t ToString(char* buff, size_t size) const NN_NOEXCEPT;
        public:
            int32_t value;
            int32_t result;
        };


    public:
        static nn::Result DecodeRequestBufferRequest(RequestBufferRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeRequestBufferReply(RequestBufferReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeSetBufferCountRequest(SetBufferCountRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeSetBufferCountReply(SetBufferCountReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeConnectRequest(ConnectRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeConnectReply(ConnectReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeDisconnectRequest(DisconnectRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeDisconnectReply(DisconnectReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeDequeueBufferRequest(DequeueBufferRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeDequeueBufferReply(DequeueBufferReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeQueueBufferRequest(QueueBufferRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeQueueBufferReply(QueueBufferReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeSetPreallocatedBufferRequest(SetPreallocatedBufferRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeSetPreallocatedBufferReply(SetPreallocatedBufferReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;

        static nn::Result DecodeQueryRequest(QueryRequest* pOutValue, const void* p, size_t size) NN_NOEXCEPT;
        static nn::Result DecodeQueryReply(QueryReply* pOutValue, const void* p, size_t size) NN_NOEXCEPT;


        static nn::Result EncodeConnectRequest(size_t* pOutSize, void* buff, size_t buffSize, const ConnectRequest& value) NN_NOEXCEPT;
        static nn::Result EncodeDisconnectRequest(size_t* pOutSize, void* buff, size_t buffSize, const DisconnectRequest& value) NN_NOEXCEPT;


        static nn::Result EncodeQueueBufferRequest(size_t* pOutSize, void* buff, size_t buffSize, const QueueBufferRequest& value) NN_NOEXCEPT;
        static nn::Result EncodeQueueBufferReply(size_t* pOutSize, void* buff, size_t buffSize, const QueueBufferReply& value) NN_NOEXCEPT;
    };

}}}}
